/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.pipeline;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.VariableContainerWrapper;
import org.flowable.eventregistry.api.ChannelModelProcessor;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.api.InboundEventDeserializer;
import org.flowable.eventregistry.api.InboundEventKeyDetector;
import org.flowable.eventregistry.api.InboundEventPayloadExtractor;
import org.flowable.eventregistry.api.InboundEventProcessingPipeline;
import org.flowable.eventregistry.api.InboundEventTenantDetector;
import org.flowable.eventregistry.api.InboundEventTransformer;
import org.flowable.eventregistry.impl.keydetector.InboundEventStaticKeyDetector;
import org.flowable.eventregistry.impl.keydetector.JsonFieldBasedInboundEventKeyDetector;
import org.flowable.eventregistry.impl.keydetector.JsonPointerBasedInboundEventKeyDetector;
import org.flowable.eventregistry.impl.keydetector.XpathBasedInboundEventKeyDetector;
import org.flowable.eventregistry.impl.payload.JsonFieldToMapPayloadExtractor;
import org.flowable.eventregistry.impl.payload.XmlElementsToMapPayloadExtractor;
import org.flowable.eventregistry.impl.pipeline.DefaultInboundEventProcessingPipeline;
import org.flowable.eventregistry.impl.serialization.StringToJsonDeserializer;
import org.flowable.eventregistry.impl.serialization.StringToXmlDocumentDeserializer;
import org.flowable.eventregistry.impl.tenantdetector.InboundEventStaticTenantDetector;
import org.flowable.eventregistry.impl.tenantdetector.JsonPointerBasedInboundEventTenantDetector;
import org.flowable.eventregistry.impl.tenantdetector.XpathBasedInboundEventTenantDetector;
import org.flowable.eventregistry.impl.transformer.DefaultInboundEventTransformer;
import org.flowable.eventregistry.impl.util.CommandContextUtil;
import org.flowable.eventregistry.model.ChannelEventKeyDetection;
import org.flowable.eventregistry.model.ChannelEventTenantIdDetection;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.InboundChannelModel;
import org.w3c.dom.Document;

public class InboundChannelModelProcessor
implements ChannelModelProcessor {
    public boolean canProcess(ChannelModel channelModel) {
        return channelModel instanceof InboundChannelModel;
    }

    public void registerChannelModel(ChannelModel channelModel, String tenantId, EventRegistry eventRegistry, EventRepositoryService eventRepositoryService, boolean fallbackToDefaultTenant) {
        if (channelModel instanceof InboundChannelModel) {
            this.registerChannelModel((InboundChannelModel)channelModel, eventRepositoryService, fallbackToDefaultTenant);
        }
    }

    protected void registerChannelModel(InboundChannelModel inboundChannelModel, EventRepositoryService eventRepositoryService, boolean fallbackToDefaultTenant) {
        Object eventProcessingPipeline;
        if (inboundChannelModel.getInboundEventProcessingPipeline() == null && (eventProcessingPipeline = StringUtils.isNotEmpty((CharSequence)inboundChannelModel.getPipelineDelegateExpression()) ? this.resolveExpression(inboundChannelModel.getPipelineDelegateExpression(), InboundEventProcessingPipeline.class) : ("json".equals(inboundChannelModel.getDeserializerType()) ? this.createJsonEventProcessingPipeline(inboundChannelModel, eventRepositoryService) : ("xml".equals(inboundChannelModel.getDeserializerType()) ? this.createXmlEventProcessingPipeline(inboundChannelModel, eventRepositoryService) : ("expression".equals(inboundChannelModel.getDeserializerType()) ? this.createExpressionEventProcessingPipeline(inboundChannelModel, eventRepositoryService) : null)))) != null) {
            inboundChannelModel.setInboundEventProcessingPipeline(eventProcessingPipeline);
        }
    }

    protected InboundEventProcessingPipeline createJsonEventProcessingPipeline(InboundChannelModel channelModel, EventRepositoryService eventRepositoryService) {
        InboundEventKeyDetector eventKeyDetector;
        StringToJsonDeserializer eventDeserializer = StringUtils.isEmpty((CharSequence)channelModel.getDeserializerDelegateExpression()) ? new StringToJsonDeserializer() : this.resolveExpression(channelModel.getDeserializerDelegateExpression(), InboundEventDeserializer.class);
        InboundEventTenantDetector eventTenantDetector = null;
        JsonFieldToMapPayloadExtractor eventPayloadExtractor = StringUtils.isEmpty((CharSequence)channelModel.getPayloadExtractorDelegateExpression()) ? new JsonFieldToMapPayloadExtractor() : this.resolveExpression(channelModel.getPayloadExtractorDelegateExpression(), InboundEventPayloadExtractor.class);
        DefaultInboundEventTransformer eventTransformer = StringUtils.isEmpty((CharSequence)channelModel.getEventTransformerDelegateExpression()) ? new DefaultInboundEventTransformer() : this.resolveExpression(channelModel.getEventTransformerDelegateExpression(), InboundEventTransformer.class);
        ChannelEventKeyDetection keyDetection = channelModel.getChannelEventKeyDetection();
        if (keyDetection == null) {
            throw new FlowableException("A channel key detection value is required");
        }
        if (StringUtils.isNotEmpty((CharSequence)keyDetection.getFixedValue())) {
            eventKeyDetector = new InboundEventStaticKeyDetector(keyDetection.getFixedValue());
        } else if (StringUtils.isNotEmpty((CharSequence)keyDetection.getJsonField())) {
            eventKeyDetector = new JsonFieldBasedInboundEventKeyDetector(keyDetection.getJsonField());
        } else if (StringUtils.isNotEmpty((CharSequence)keyDetection.getJsonPointerExpression())) {
            eventKeyDetector = new JsonPointerBasedInboundEventKeyDetector(keyDetection.getJsonPointerExpression());
        } else if (StringUtils.isNotEmpty((CharSequence)keyDetection.getDelegateExpression())) {
            eventKeyDetector = this.resolveExpression(keyDetection.getDelegateExpression(), InboundEventKeyDetector.class);
        } else {
            throw new FlowableException("The channel json key detection value was not found for the channel model with key " + channelModel.getKey() + ". One of fixedValue, jsonField, jsonPointerExpression or delegateExpression should be set.");
        }
        ChannelEventTenantIdDetection channelEventTenantIdDetection = channelModel.getChannelEventTenantIdDetection();
        if (channelEventTenantIdDetection != null) {
            if (StringUtils.isNotEmpty((CharSequence)channelEventTenantIdDetection.getFixedValue())) {
                eventTenantDetector = new InboundEventStaticTenantDetector(channelEventTenantIdDetection.getFixedValue());
            } else if (StringUtils.isNotEmpty((CharSequence)channelEventTenantIdDetection.getJsonPointerExpression())) {
                eventTenantDetector = new JsonPointerBasedInboundEventTenantDetector(channelEventTenantIdDetection.getJsonPointerExpression());
            } else if (StringUtils.isNotEmpty((CharSequence)channelEventTenantIdDetection.getDelegateExpression())) {
                eventTenantDetector = this.resolveExpression(channelEventTenantIdDetection.getDelegateExpression(), InboundEventTenantDetector.class);
            } else {
                throw new FlowableException("The channel json tenant detection value was not found for the channel model with key " + channelModel.getKey() + ". One of fixedValue, jsonPointerExpression, delegateExpression should be set.");
            }
        }
        return new DefaultInboundEventProcessingPipeline<JsonNode>(eventRepositoryService, eventDeserializer, eventKeyDetector, eventTenantDetector, eventPayloadExtractor, eventTransformer);
    }

    protected InboundEventProcessingPipeline createXmlEventProcessingPipeline(InboundChannelModel channelModel, EventRepositoryService eventRepositoryService) {
        InboundEventKeyDetector eventKeyDetector;
        StringToXmlDocumentDeserializer eventDeserializer = StringUtils.isEmpty((CharSequence)channelModel.getDeserializerDelegateExpression()) ? new StringToXmlDocumentDeserializer() : this.resolveExpression(channelModel.getDeserializerDelegateExpression(), InboundEventDeserializer.class);
        InboundEventTenantDetector eventTenantDetector = null;
        XmlElementsToMapPayloadExtractor eventPayloadExtractor = StringUtils.isEmpty((CharSequence)channelModel.getPayloadExtractorDelegateExpression()) ? new XmlElementsToMapPayloadExtractor() : this.resolveExpression(channelModel.getPayloadExtractorDelegateExpression(), InboundEventPayloadExtractor.class);
        DefaultInboundEventTransformer eventTransformer = StringUtils.isEmpty((CharSequence)channelModel.getEventTransformerDelegateExpression()) ? new DefaultInboundEventTransformer() : this.resolveExpression(channelModel.getEventTransformerDelegateExpression(), InboundEventTransformer.class);
        ChannelEventKeyDetection keyDetection = channelModel.getChannelEventKeyDetection();
        if (keyDetection == null) {
            throw new FlowableException("A channel key detection value is required");
        }
        if (StringUtils.isNotEmpty((CharSequence)keyDetection.getFixedValue())) {
            eventKeyDetector = new InboundEventStaticKeyDetector(keyDetection.getFixedValue());
        } else if (StringUtils.isNotEmpty((CharSequence)keyDetection.getXmlXPathExpression())) {
            eventKeyDetector = new XpathBasedInboundEventKeyDetector(keyDetection.getXmlXPathExpression());
        } else if (StringUtils.isNotEmpty((CharSequence)keyDetection.getDelegateExpression())) {
            eventKeyDetector = this.resolveExpression(keyDetection.getDelegateExpression(), InboundEventKeyDetector.class);
        } else {
            throw new FlowableException("The channel xml key detection value was not found for the channel model with key " + channelModel.getKey() + ". One of fixedValue, xmlPathExpression, delegateExpression should be set.");
        }
        ChannelEventTenantIdDetection channelEventTenantIdDetection = channelModel.getChannelEventTenantIdDetection();
        if (channelEventTenantIdDetection != null) {
            if (StringUtils.isNotEmpty((CharSequence)channelEventTenantIdDetection.getFixedValue())) {
                eventTenantDetector = new InboundEventStaticTenantDetector(channelEventTenantIdDetection.getFixedValue());
            } else if (StringUtils.isNotEmpty((CharSequence)channelEventTenantIdDetection.getxPathExpression())) {
                eventTenantDetector = new XpathBasedInboundEventTenantDetector(channelEventTenantIdDetection.getxPathExpression());
            } else if (StringUtils.isNotEmpty((CharSequence)channelEventTenantIdDetection.getDelegateExpression())) {
                eventTenantDetector = this.resolveExpression(channelEventTenantIdDetection.getDelegateExpression(), InboundEventTenantDetector.class);
            } else {
                throw new FlowableException("The channel xml tenant detection value was not found for the channel model with key " + channelModel.getKey() + ". One of fixedValue, xPathExpression, delegateExpression should be set.");
            }
        }
        return new DefaultInboundEventProcessingPipeline<Document>(eventRepositoryService, eventDeserializer, eventKeyDetector, eventTenantDetector, eventPayloadExtractor, eventTransformer);
    }

    protected InboundEventProcessingPipeline createExpressionEventProcessingPipeline(InboundChannelModel channelModel, EventRepositoryService eventRepositoryService) {
        Object eventKeyDetector;
        if (!StringUtils.isNotEmpty((CharSequence)channelModel.getDeserializerDelegateExpression())) {
            throw new FlowableException("The channel deserializer expression for the channel model with key " + channelModel.getKey() + " was empty. The deserializerDelegateExpression has to be provided for a channel with an expression deserializer.");
        }
        InboundEventDeserializer eventDeserializer = this.resolveExpression(channelModel.getDeserializerDelegateExpression(), InboundEventDeserializer.class);
        Object eventTenantDetector = null;
        if (!StringUtils.isNotEmpty((CharSequence)channelModel.getPayloadExtractorDelegateExpression())) {
            throw new FlowableException("The channel payload extractor expression for the channel model with key " + channelModel.getKey() + " was empty. The payloadExtractorExpression has to be provided for a channel with an expression deserializer.");
        }
        InboundEventPayloadExtractor eventPayloadExtractor = this.resolveExpression(channelModel.getPayloadExtractorDelegateExpression(), InboundEventPayloadExtractor.class);
        DefaultInboundEventTransformer eventTransformer = StringUtils.isEmpty((CharSequence)channelModel.getEventTransformerDelegateExpression()) ? new DefaultInboundEventTransformer() : this.resolveExpression(channelModel.getEventTransformerDelegateExpression(), InboundEventTransformer.class);
        ChannelEventKeyDetection keyDetection = channelModel.getChannelEventKeyDetection();
        if (keyDetection == null) {
            throw new FlowableException("A channel key detection value is required");
        }
        if (StringUtils.isNotEmpty((CharSequence)keyDetection.getDelegateExpression())) {
            eventKeyDetector = this.resolveExpression(keyDetection.getDelegateExpression(), InboundEventKeyDetector.class);
        } else if (StringUtils.isNotEmpty((CharSequence)keyDetection.getFixedValue())) {
            eventKeyDetector = new InboundEventStaticKeyDetector(keyDetection.getFixedValue());
        } else if (StringUtils.isNotEmpty((CharSequence)keyDetection.getJsonField())) {
            eventKeyDetector = new JsonFieldBasedInboundEventKeyDetector(keyDetection.getJsonField());
        } else if (StringUtils.isNotEmpty((CharSequence)keyDetection.getJsonPointerExpression())) {
            eventKeyDetector = new JsonPointerBasedInboundEventKeyDetector(keyDetection.getJsonPointerExpression());
        } else if (StringUtils.isNotEmpty((CharSequence)keyDetection.getXmlXPathExpression())) {
            eventKeyDetector = new XpathBasedInboundEventKeyDetector(keyDetection.getXmlXPathExpression());
        } else {
            throw new FlowableException("The channel expression key detection value was not found for the channel model with key " + channelModel.getKey() + ". One of fixedValue, jsonField, jsonPointerExpression, xmlXPathExpression, delegateExpression should be set.");
        }
        ChannelEventTenantIdDetection channelEventTenantIdDetection = channelModel.getChannelEventTenantIdDetection();
        if (channelEventTenantIdDetection != null) {
            if (StringUtils.isNotEmpty((CharSequence)channelEventTenantIdDetection.getDelegateExpression())) {
                eventTenantDetector = this.resolveExpression(channelEventTenantIdDetection.getDelegateExpression(), InboundEventTenantDetector.class);
            } else if (StringUtils.isNotEmpty((CharSequence)channelEventTenantIdDetection.getFixedValue())) {
                eventTenantDetector = new InboundEventStaticTenantDetector(channelEventTenantIdDetection.getFixedValue());
            } else if (StringUtils.isNotEmpty((CharSequence)channelEventTenantIdDetection.getJsonPointerExpression())) {
                eventTenantDetector = new JsonPointerBasedInboundEventTenantDetector(channelEventTenantIdDetection.getJsonPointerExpression());
            } else if (StringUtils.isNotEmpty((CharSequence)channelEventTenantIdDetection.getxPathExpression())) {
                eventTenantDetector = new XpathBasedInboundEventTenantDetector(channelEventTenantIdDetection.getxPathExpression());
            } else {
                throw new FlowableException("The channel expression tenant detection value was not found for the channel model with key " + channelModel.getKey() + ". One of fixedValue, jsonField, jsonPointerExpression, xmlXPathExpression, delegateExpression should be set.");
            }
        }
        return new DefaultInboundEventProcessingPipeline(eventRepositoryService, eventDeserializer, eventKeyDetector, eventTenantDetector, eventPayloadExtractor, eventTransformer);
    }

    protected <T> T resolveExpression(String expression, Class<T> type) {
        Object value = CommandContextUtil.getEventRegistryConfiguration().getExpressionManager().createExpression(expression).getValue((VariableContainer)new VariableContainerWrapper(Collections.emptyMap()));
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        throw new FlowableException("expected expression " + expression + " to resolve to " + type + " but it did not. Resolved value is " + value);
    }

    public void unregisterChannelModel(ChannelModel channelModel, String tenantId, EventRepositoryService eventRepositoryService) {
    }
}

