/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRegistryEvent;
import org.flowable.eventregistry.api.EventRegistryEventConsumer;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.consumer.CorrelationKey;
import org.flowable.eventregistry.impl.util.CommandContextUtil;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.api.EventSubscriptionQuery;

public abstract class BaseEventRegistryEventConsumer
implements EventRegistryEventConsumer {
    protected AbstractEngineConfiguration engingeConfiguration;
    protected CommandExecutor commandExecutor;

    public BaseEventRegistryEventConsumer(AbstractEngineConfiguration engingeConfiguration) {
        this.engingeConfiguration = engingeConfiguration;
        this.commandExecutor = engingeConfiguration.getCommandExecutor();
    }

    public void eventReceived(EventRegistryEvent event) {
        if (event.getEventObject() == null || !(event.getEventObject() instanceof EventInstance)) {
            if (event.getEventObject() == null) {
                throw new FlowableIllegalArgumentException("No event object was passed to the consumer");
            }
            throw new FlowableIllegalArgumentException("Unsupported event object type: " + event.getEventObject().getClass());
        }
        this.eventReceived((EventInstance)event.getEventObject());
    }

    protected abstract void eventReceived(EventInstance var1);

    protected Collection<CorrelationKey> generateCorrelationKeys(Collection<EventPayloadInstance> correlationParameterInstances) {
        if (correlationParameterInstances.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<EventPayloadInstance> list = new ArrayList<EventPayloadInstance>(correlationParameterInstances);
        HashSet<CorrelationKey> correlationKeys = new HashSet<CorrelationKey>();
        for (int i = 1; i <= list.size(); ++i) {
            for (int j = 0; j <= list.size() - i; ++j) {
                List<EventPayloadInstance> parameterSubList = list.subList(j, j + i);
                String correlationKey = this.generateCorrelationKey(parameterSubList);
                correlationKeys.add(new CorrelationKey(correlationKey, parameterSubList));
            }
        }
        return correlationKeys;
    }

    protected String generateCorrelationKey(Collection<EventPayloadInstance> correlationParameterInstances) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (EventPayloadInstance correlationParameterInstance : correlationParameterInstances) {
            data.put(correlationParameterInstance.getDefinitionName(), correlationParameterInstance.getValue());
        }
        return this.getEventRegistry().generateKey(data);
    }

    protected EventRegistry getEventRegistry() {
        EventRegistryEngineConfiguration eventRegistryEngineConfiguration = (EventRegistryEngineConfiguration)((Object)this.engingeConfiguration.getEngineConfigurations().get("cfg.eventRegistry"));
        return eventRegistryEngineConfiguration.getEventRegistry();
    }

    protected CorrelationKey getCorrelationKeyWithAllParameters(Collection<CorrelationKey> correlationKeys) {
        CorrelationKey result = null;
        for (CorrelationKey correlationKey : correlationKeys) {
            if (result != null && correlationKey.getParameterInstances().size() < result.getParameterInstances().size()) continue;
            result = correlationKey;
        }
        return result;
    }

    protected List<EventSubscription> findEventSubscriptions(String scopeType, EventInstance eventInstance, Collection<CorrelationKey> correlationKeys) {
        return (List)this.commandExecutor.execute(commandContext -> {
            EventSubscriptionQuery eventSubscriptionQuery = this.createEventSubscriptionQuery().eventType(eventInstance.getEventKey()).scopeType(scopeType);
            if (!correlationKeys.isEmpty()) {
                Set allCorrelationKeyValues = correlationKeys.stream().map(CorrelationKey::getValue).collect(Collectors.toSet());
                eventSubscriptionQuery.or().withoutConfiguration().configurations(allCorrelationKeyValues).endOr();
            } else {
                eventSubscriptionQuery.withoutConfiguration();
            }
            String eventInstanceTenantId = eventInstance.getTenantId();
            if (eventInstanceTenantId != null && !"".equals(eventInstanceTenantId)) {
                EventRegistryEngineConfiguration eventRegistryConfiguration = CommandContextUtil.getEventRegistryConfiguration();
                if (eventRegistryConfiguration.isFallbackToDefaultTenant()) {
                    String defaultTenant = eventRegistryConfiguration.getDefaultTenantProvider().getDefaultTenant(eventInstance.getTenantId(), scopeType, eventInstance.getEventKey());
                    if ("".equals(defaultTenant)) {
                        eventSubscriptionQuery.or().tenantId(eventInstance.getTenantId()).withoutTenantId().endOr();
                    } else {
                        eventSubscriptionQuery.tenantIds(Arrays.asList(eventInstanceTenantId, defaultTenant));
                    }
                } else {
                    eventSubscriptionQuery.tenantId(eventInstanceTenantId);
                }
            }
            return eventSubscriptionQuery.list();
        });
    }

    protected abstract EventSubscriptionQuery createEventSubscriptionQuery();
}

