/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.eventregistry.api.EventDeployment;
import org.flowable.eventregistry.impl.EventDeploymentQueryImpl;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.persistence.deploy.EventDefinitionCacheEntry;
import org.flowable.eventregistry.impl.persistence.deploy.EventDeploymentManager;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntityManager;
import org.flowable.eventregistry.impl.util.CommandContextUtil;
import org.flowable.eventregistry.model.EventModel;

public class GetEventModelCmd
implements Command<EventModel>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String eventDefinitionKey;
    protected String eventDefinitionId;
    protected String tenantId;
    protected String parentDeploymentId;

    public GetEventModelCmd(String eventDefinitionKey, String eventDefinitionId) {
        this.eventDefinitionKey = eventDefinitionKey;
        this.eventDefinitionId = eventDefinitionId;
    }

    public GetEventModelCmd(String eventDefinitionKey, String tenantId, String parentDeploymentId) {
        this(eventDefinitionKey, null);
        this.parentDeploymentId = parentDeploymentId;
        this.tenantId = tenantId;
    }

    public EventModel execute(CommandContext commandContext) {
        List<EventDeployment> eventDeployments;
        EventRegistryEngineConfiguration eventEngineConfiguration = CommandContextUtil.getEventRegistryConfiguration(commandContext);
        EventDeploymentManager deploymentManager = eventEngineConfiguration.getDeploymentManager();
        EventDefinitionEntityManager eventDefinitionEntityManager = eventEngineConfiguration.getEventDefinitionEntityManager();
        EventDefinitionEntity eventDefinitionEntity = null;
        if (this.eventDefinitionId != null) {
            eventDefinitionEntity = deploymentManager.findDeployedEventDefinitionById(this.eventDefinitionId);
            if (eventDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No event definition found for id = '" + this.eventDefinitionId + "'", EventDefinitionEntity.class);
            }
        } else if (this.eventDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && (this.parentDeploymentId == null || eventEngineConfiguration.isAlwaysLookupLatestDefinitionVersion())) {
            eventDefinitionEntity = deploymentManager.findDeployedLatestEventDefinitionByKey(this.eventDefinitionKey);
            if (eventDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No event definition found for key '" + this.eventDefinitionKey + "'", EventDefinitionEntity.class);
            }
        } else if (this.eventDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && (this.parentDeploymentId == null || eventEngineConfiguration.isAlwaysLookupLatestDefinitionVersion())) {
            eventDefinitionEntity = eventDefinitionEntityManager.findLatestEventDefinitionByKeyAndTenantId(this.eventDefinitionKey, this.tenantId);
            if (eventDefinitionEntity == null && eventEngineConfiguration.isFallbackToDefaultTenant()) {
                String defaultTenant = eventEngineConfiguration.getDefaultTenantProvider().getDefaultTenant(this.tenantId, "eventRegistry", this.eventDefinitionKey);
                eventDefinitionEntity = StringUtils.isNotEmpty((CharSequence)defaultTenant) ? eventDefinitionEntityManager.findLatestEventDefinitionByKeyAndTenantId(this.eventDefinitionKey, defaultTenant) : eventDefinitionEntityManager.findLatestEventDefinitionByKey(this.eventDefinitionKey);
            }
            if (eventDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No event definition found for key '" + this.eventDefinitionKey + "' for tenant identifier '" + this.tenantId + "'", EventDefinitionEntity.class);
            }
        } else if (this.eventDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId != null) {
            eventDeployments = deploymentManager.getDeploymentEntityManager().findDeploymentsByQueryCriteria(new EventDeploymentQueryImpl().parentDeploymentId(this.parentDeploymentId));
            if (eventDeployments != null && eventDeployments.size() > 0) {
                eventDefinitionEntity = eventDefinitionEntityManager.findEventDefinitionByDeploymentAndKey(eventDeployments.get(0).getId(), this.eventDefinitionKey);
            }
            if (eventDefinitionEntity == null) {
                eventDefinitionEntity = eventDefinitionEntityManager.findLatestEventDefinitionByKey(this.eventDefinitionKey);
            }
            if (eventDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No event definition found for key '" + this.eventDefinitionKey + "' for parent deployment id " + this.parentDeploymentId, EventDefinitionEntity.class);
            }
        } else if (this.eventDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId != null) {
            eventDeployments = deploymentManager.getDeploymentEntityManager().findDeploymentsByQueryCriteria(new EventDeploymentQueryImpl().parentDeploymentId(this.parentDeploymentId).deploymentTenantId(this.tenantId));
            if (eventDeployments != null && eventDeployments.size() > 0) {
                eventDefinitionEntity = eventDefinitionEntityManager.findEventDefinitionByDeploymentAndKeyAndTenantId(eventDeployments.get(0).getId(), this.eventDefinitionKey, this.tenantId);
            }
            if (eventDefinitionEntity == null) {
                eventDefinitionEntity = eventDefinitionEntityManager.findLatestEventDefinitionByKeyAndTenantId(this.eventDefinitionKey, this.tenantId);
            }
            if (eventDefinitionEntity == null && eventEngineConfiguration.isFallbackToDefaultTenant()) {
                String defaultTenant = eventEngineConfiguration.getDefaultTenantProvider().getDefaultTenant(this.tenantId, "eventRegistry", this.eventDefinitionKey);
                eventDefinitionEntity = StringUtils.isNotEmpty((CharSequence)defaultTenant) ? eventDefinitionEntityManager.findLatestEventDefinitionByKeyAndTenantId(this.eventDefinitionKey, defaultTenant) : eventDefinitionEntityManager.findLatestEventDefinitionByKey(this.eventDefinitionKey);
            }
            if (eventDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No event definition found for key '" + this.eventDefinitionKey + " for parent deployment id '" + this.parentDeploymentId + "' and for tenant identifier " + this.tenantId, EventDefinitionEntity.class);
            }
        } else {
            throw new FlowableObjectNotFoundException("eventDefinitionKey and eventDefinitionId are null");
        }
        EventDefinitionCacheEntry eventDefinitionCacheEntry = deploymentManager.resolveEventDefinition(eventDefinitionEntity);
        return eventEngineConfiguration.getEventJsonConverter().convertToEventModel(eventDefinitionCacheEntry.getEventDefinitionJson());
    }
}

