/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.serialization;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.eventregistry.api.OutboundEventSerializer;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EventPayloadToXmlStringSerializer
implements OutboundEventSerializer {
    public String serialize(EventInstance eventInstance) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement(eventInstance.getEventModel().getKey());
            doc.appendChild(rootElement);
            if (!eventInstance.getPayloadInstances().isEmpty()) {
                for (EventPayloadInstance payloadInstance : eventInstance.getPayloadInstances()) {
                    Element element = doc.createElement(payloadInstance.getDefinitionName());
                    element.setTextContent(payloadInstance.getValue().toString());
                    rootElement.appendChild(element);
                }
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            return writer.toString();
        }
        catch (Exception e) {
            throw new FlowableException("Could not serialize eventInstance to xml string", (Throwable)e);
        }
    }
}

