/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.rabbit;

import org.flowable.eventregistry.api.OutboundEventChannelAdapter;
import org.springframework.amqp.rabbit.core.RabbitOperations;

public class RabbitOperationsOutboundEventChannelAdapter
implements OutboundEventChannelAdapter {
    protected RabbitOperations rabbitOperations;
    protected String exchange;
    protected String routingKey;

    public RabbitOperationsOutboundEventChannelAdapter(RabbitOperations rabbitOperations, String exchange, String routingKey) {
        this.rabbitOperations = rabbitOperations;
        this.exchange = exchange;
        this.routingKey = routingKey;
    }

    public void sendEvent(String rawEvent) {
        if (this.exchange != null) {
            this.rabbitOperations.convertAndSend(this.exchange, this.routingKey, (Object)rawEvent);
        } else {
            this.rabbitOperations.convertAndSend(this.routingKey, (Object)rawEvent);
        }
    }

    public RabbitOperations getRabbitOperations() {
        return this.rabbitOperations;
    }

    public void setRabbitOperations(RabbitOperations rabbitOperations) {
        this.rabbitOperations = rabbitOperations;
    }

    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }
}

