/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.rest.service.api.repository;

import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.ContentType;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.flowable.eventregistry.api.EventDeployment;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.rest.service.api.EventRegistryRestApiInterceptor;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseDeploymentResourceDataResource {
    @Autowired
    protected ContentTypeResolver contentTypeResolver;
    @Autowired
    protected EventRepositoryService repositoryService;
    @Autowired(required=false)
    protected EventRegistryRestApiInterceptor restApiInterceptor;

    protected byte[] getDeploymentResourceData(String deploymentId, String resourceName, HttpServletResponse response) {
        List resourceList;
        if (deploymentId == null) {
            throw new FlowableIllegalArgumentException("No deployment id provided");
        }
        if (resourceName == null) {
            throw new FlowableIllegalArgumentException("No resource name provided");
        }
        EventDeployment deployment = (EventDeployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.", EventDeployment.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessDeploymentById(deployment);
        }
        if ((resourceList = this.repositoryService.getDeploymentResourceNames(deploymentId)).contains(resourceName)) {
            byte[] byArray;
            block13: {
                String contentType = null;
                contentType = resourceName.toLowerCase().endsWith(".event") || resourceName.toLowerCase().endsWith(".channel") ? ContentType.APPLICATION_JSON.getMimeType() : this.contentTypeResolver.resolveContentType(resourceName);
                response.setContentType(contentType);
                InputStream resourceStream = this.repositoryService.getResourceAsStream(deploymentId, resourceName);
                try {
                    byArray = IOUtils.toByteArray((InputStream)resourceStream);
                    if (resourceStream == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (resourceStream != null) {
                            try {
                                resourceStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new FlowableException("Error converting resource stream", (Throwable)e);
                    }
                }
                resourceStream.close();
            }
            return byArray;
        }
        throw new FlowableObjectNotFoundException("Could not find a resource with name '" + resourceName + "' in deployment '" + deploymentId + "'.", String.class);
    }
}

