/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.entitylink.service.impl.persistence.entity;

import java.util.List;
import org.flowable.common.engine.impl.AbstractServiceConfiguration;
import org.flowable.common.engine.impl.persistence.entity.AbstractServiceEngineEntityManager;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.entitylink.api.EntityLink;
import org.flowable.entitylink.service.EntityLinkServiceConfiguration;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntityManager;
import org.flowable.entitylink.service.impl.persistence.entity.data.EntityLinkDataManager;

public class EntityLinkEntityManagerImpl
extends AbstractServiceEngineEntityManager<EntityLinkServiceConfiguration, EntityLinkEntity, EntityLinkDataManager>
implements EntityLinkEntityManager {
    public EntityLinkEntityManagerImpl(EntityLinkServiceConfiguration entityLinkServiceConfiguration, EntityLinkDataManager entityLinkDataManager) {
        super((AbstractServiceConfiguration)entityLinkServiceConfiguration, (DataManager)entityLinkDataManager);
    }

    public EntityLinkEntity create() {
        EntityLinkEntity entityLinkEntity = (EntityLinkEntity)super.create();
        entityLinkEntity.setCreateTime(this.getClock().getCurrentTime());
        return entityLinkEntity;
    }

    @Override
    public List<EntityLink> findEntityLinksByScopeIdAndType(String scopeId, String scopeType, String linkType) {
        return ((EntityLinkDataManager)this.dataManager).findEntityLinksByScopeIdAndType(scopeId, scopeType, linkType);
    }

    @Override
    public List<EntityLink> findEntityLinksByReferenceScopeIdAndType(String referenceScopeId, String referenceScopeType, String linkType) {
        return ((EntityLinkDataManager)this.dataManager).findEntityLinksByReferenceScopeIdAndType(referenceScopeId, referenceScopeType, linkType);
    }

    @Override
    public List<EntityLink> findEntityLinksByScopeDefinitionIdAndType(String scopeDefinitionId, String scopeType, String linkType) {
        return ((EntityLinkDataManager)this.dataManager).findEntityLinksByScopeDefinitionIdAndType(scopeDefinitionId, scopeType, linkType);
    }

    @Override
    public List<EntityLink> deleteScopeEntityLink(String scopeId, String scopeType, String linkType) {
        List<EntityLink> entityLinks = this.findEntityLinksByScopeIdAndType(scopeId, scopeType, linkType);
        for (EntityLink entityLink : entityLinks) {
            this.deleteEntityLink((EntityLinkEntity)entityLink);
        }
        return entityLinks;
    }

    @Override
    public List<EntityLink> deleteScopeDefinitionEntityLink(String scopeDefinitionId, String scopeType, String linkType) {
        List<EntityLink> entityLinks = this.findEntityLinksByScopeDefinitionIdAndType(scopeDefinitionId, scopeType, linkType);
        for (EntityLink entityLink : entityLinks) {
            this.deleteEntityLink((EntityLinkEntity)entityLink);
        }
        return entityLinks;
    }

    public void deleteEntityLink(EntityLinkEntity identityLink) {
        this.delete(identityLink);
    }

    @Override
    public void deleteEntityLinksByScopeIdAndScopeType(String scopeId, String scopeType) {
        ((EntityLinkDataManager)this.dataManager).deleteEntityLinksByScopeIdAndScopeType(scopeId, scopeType);
    }

    @Override
    public void deleteEntityLinksByScopeDefinitionIdAndScopeType(String scopeDefinitionId, String scopeType) {
        ((EntityLinkDataManager)this.dataManager).deleteEntityLinksByScopeDefinitionIdAndScopeType(scopeDefinitionId, scopeType);
    }
}

