/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.HistoryConfigurationSettings;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ActivityInstance;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHistoryConfigurationSettings
implements HistoryConfigurationSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DefaultHistoryConfigurationSettings.class.getName());
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public DefaultHistoryConfigurationSettings(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    protected boolean isEnableProcessDefinitionHistoryLevel() {
        return this.processEngineConfiguration.isEnableProcessDefinitionHistoryLevel();
    }

    @Override
    public boolean isHistoryEnabled() {
        HistoryLevel engineHistoryLevel = this.processEngineConfiguration.getHistoryLevel();
        return engineHistoryLevel != HistoryLevel.NONE;
    }

    protected HistoryLevel getProcessDefinitionHistoryLevel(String processDefinitionId) {
        HistoryLevel processDefinitionHistoryLevel = null;
        try {
            ExtensionElement historyLevelElement;
            String historyLevelValue;
            ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(processDefinitionId);
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId);
            Process process = bpmnModel.getProcessById(processDefinition.getKey());
            if (process.getExtensionElements().containsKey("historyLevel") && StringUtils.isNotEmpty((CharSequence)(historyLevelValue = (historyLevelElement = (ExtensionElement)((List)process.getExtensionElements().get("historyLevel")).iterator().next()).getElementText()))) {
                try {
                    processDefinitionHistoryLevel = HistoryLevel.getHistoryLevelForKey((String)historyLevelValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (processDefinitionHistoryLevel == null) {
                processDefinitionHistoryLevel = this.processEngineConfiguration.getHistoryLevel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return processDefinitionHistoryLevel;
    }

    @Override
    public boolean isHistoryEnabled(String processDefinitionId) {
        HistoryLevel engineHistoryLevel = this.processEngineConfiguration.getHistoryLevel();
        if (this.isEnableProcessDefinitionHistoryLevel() && processDefinitionId != null) {
            HistoryLevel processDefinitionLevel = this.getProcessDefinitionHistoryLevel(processDefinitionId);
            if (processDefinitionLevel != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Current history level: {}", (Object)processDefinitionLevel);
                }
                return !processDefinitionLevel.equals((Object)HistoryLevel.NONE);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Current history level: {}", (Object)engineHistoryLevel);
            }
            return !engineHistoryLevel.equals((Object)HistoryLevel.NONE);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Current history level: {}", (Object)engineHistoryLevel);
        }
        return !engineHistoryLevel.equals((Object)HistoryLevel.NONE);
    }

    @Override
    public boolean isHistoryLevelAtLeast(HistoryLevel level, String processDefinitionId) {
        HistoryLevel engineHistoryLevel = this.processEngineConfiguration.getHistoryLevel();
        if (this.isEnableProcessDefinitionHistoryLevel() && processDefinitionId != null) {
            HistoryLevel processDefinitionLevel = this.getProcessDefinitionHistoryLevel(processDefinitionId);
            if (processDefinitionLevel != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Current history level: {}, level required: {}", (Object)processDefinitionLevel, (Object)level);
                }
                return processDefinitionLevel.isAtLeast(level);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Current history level: {}, level required: {}", (Object)engineHistoryLevel, (Object)level);
            }
            return engineHistoryLevel.isAtLeast(level);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Current history level: {}, level required: {}", (Object)engineHistoryLevel, (Object)level);
        }
        return engineHistoryLevel.isAtLeast(level);
    }

    @Override
    public boolean isHistoryEnabledForProcessInstance(ExecutionEntity processInstanceExecution) {
        return this.isHistoryLevelAtLeast(HistoryLevel.INSTANCE, processInstanceExecution.getProcessDefinitionId());
    }

    @Override
    public boolean isHistoryEnabledForActivity(ActivityInstance activityInstance) {
        return this.isHistoryEnabledForActivity(activityInstance.getProcessDefinitionId(), activityInstance.getActivityId());
    }

    @Override
    public boolean isHistoryEnabledForActivity(String processDefinitionId, String activityId) {
        HistoryLevel engineHistoryLevel = this.processEngineConfiguration.getHistoryLevel();
        if (this.isEnableProcessDefinitionHistoryLevel() && processDefinitionId != null) {
            HistoryLevel processDefinitionLevel = this.getProcessDefinitionHistoryLevel(processDefinitionId);
            if (processDefinitionLevel != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Current history level: {}, level required: {}", (Object)processDefinitionLevel, (Object)HistoryLevel.ACTIVITY);
                }
                if (processDefinitionLevel.isAtLeast(HistoryLevel.ACTIVITY)) {
                    return true;
                }
                if (!HistoryLevel.NONE.equals((Object)processDefinitionLevel) && StringUtils.isNotEmpty((CharSequence)activityId)) {
                    return this.includeFlowElementInHistory(processDefinitionId, activityId);
                }
                return false;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Current history level: {}, level required: {}", (Object)engineHistoryLevel, (Object)HistoryLevel.ACTIVITY);
            }
            return engineHistoryLevel.isAtLeast(HistoryLevel.ACTIVITY);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Current history level: {}, level required: {}", (Object)engineHistoryLevel, (Object)HistoryLevel.ACTIVITY);
        }
        if (engineHistoryLevel.isAtLeast(HistoryLevel.ACTIVITY)) {
            return true;
        }
        if (!HistoryLevel.NONE.equals((Object)engineHistoryLevel) && StringUtils.isNotEmpty((CharSequence)activityId)) {
            return this.includeFlowElementInHistory(processDefinitionId, activityId);
        }
        return false;
    }

    protected boolean includeFlowElementInHistory(String processDefinitionId, String activityId) {
        BpmnModel bpmnModel;
        FlowElement flowElement;
        boolean includeInHistory = false;
        if (processDefinitionId != null && (flowElement = (bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId)).getFlowElement(activityId)).getExtensionElements().containsKey("includeInHistory")) {
            ExtensionElement historyElement = (ExtensionElement)((List)flowElement.getExtensionElements().get("includeInHistory")).iterator().next();
            String historyLevelValue = historyElement.getElementText();
            includeInHistory = Boolean.valueOf(historyLevelValue);
        }
        return includeInHistory;
    }

    @Override
    public boolean isHistoryEnabledForUserTask(TaskInfo taskInfo) {
        return this.isHistoryEnabledForUserTask(taskInfo.getProcessDefinitionId());
    }

    @Override
    public boolean isHistoryEnabledForUserTask(ExecutionEntity executionEntity, TaskEntity taskEntity) {
        String processDefinitionId = null;
        if (executionEntity != null) {
            processDefinitionId = executionEntity.getProcessDefinitionId();
        } else if (taskEntity != null) {
            processDefinitionId = taskEntity.getProcessDefinitionId();
        }
        return this.isHistoryEnabledForUserTask(processDefinitionId);
    }

    protected boolean isHistoryEnabledForUserTask(String processDefinitionId) {
        HistoryLevel engineHistoryLevel = this.processEngineConfiguration.getHistoryLevel();
        if (this.isEnableProcessDefinitionHistoryLevel() && processDefinitionId != null) {
            HistoryLevel processDefinitionLevel = this.getProcessDefinitionHistoryLevel(processDefinitionId);
            if (processDefinitionLevel != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Current history level: {}, level required: {}", (Object)processDefinitionLevel, (Object)HistoryLevel.TASK);
                }
                return this.hasTaskHistoryLevel(processDefinitionLevel);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Current history level: {}, level required: {}", (Object)engineHistoryLevel, (Object)HistoryLevel.TASK);
            }
            return this.hasTaskHistoryLevel(engineHistoryLevel);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Current history level: {}, level required: {}", (Object)engineHistoryLevel, (Object)HistoryLevel.TASK);
        }
        return this.hasTaskHistoryLevel(engineHistoryLevel);
    }

    protected boolean hasTaskHistoryLevel(HistoryLevel historyLevel) {
        boolean taskHistoryLevel = false;
        if (HistoryLevel.TASK.equals((Object)historyLevel)) {
            taskHistoryLevel = true;
        } else if (historyLevel.isAtLeast(HistoryLevel.AUDIT)) {
            taskHistoryLevel = true;
        }
        return taskHistoryLevel;
    }

    @Override
    public boolean isHistoryEnabledForVariableInstance(VariableInstanceEntity variableInstanceEntity) {
        String processDefinitionId = null;
        if (this.isEnableProcessDefinitionHistoryLevel() && variableInstanceEntity.getProcessInstanceId() != null) {
            ExecutionEntity processInstanceExecution = (ExecutionEntity)this.processEngineConfiguration.getExecutionEntityManager().findById(variableInstanceEntity.getProcessInstanceId());
            processDefinitionId = processInstanceExecution.getProcessDefinitionId();
        }
        return this.isHistoryEnabledForVariableInstance(processDefinitionId, variableInstanceEntity);
    }

    @Override
    public boolean isHistoryEnabledForVariableInstance(String processDefinitionId, VariableInstanceEntity variableInstanceEntity) {
        return this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processDefinitionId);
    }

    @Override
    public boolean isHistoryEnabledForIdentityLink(IdentityLinkEntity identityLink) {
        String processDefinitionId = this.getProcessDefinitionId(identityLink);
        return this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, processDefinitionId);
    }

    protected String getProcessDefinitionId(IdentityLinkEntity identityLink) {
        TaskEntity task;
        String processDefinitionId = null;
        if (identityLink.getProcessInstanceId() != null) {
            ExecutionEntity execution = (ExecutionEntity)this.processEngineConfiguration.getExecutionEntityManager().findById(identityLink.getProcessInstanceId());
            if (execution != null) {
                processDefinitionId = execution.getProcessDefinitionId();
            }
        } else if (identityLink.getTaskId() != null && (task = this.processEngineConfiguration.getTaskServiceConfiguration().getTaskService().getTask(identityLink.getTaskId())) != null) {
            processDefinitionId = task.getProcessDefinitionId();
        }
        return processDefinitionId;
    }

    @Override
    public boolean isHistoryEnabledForEntityLink(EntityLinkEntity entityLink) {
        String processDefinitionId = this.getProcessDefinitionId(entityLink);
        return this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, processDefinitionId);
    }

    protected String getProcessDefinitionId(EntityLinkEntity entityLink) {
        TaskEntity task;
        String processDefinitionId = null;
        if ("bpmn".equals(entityLink.getScopeType()) && entityLink.getScopeId() != null) {
            ExecutionEntity execution = (ExecutionEntity)this.processEngineConfiguration.getExecutionEntityManager().findById(entityLink.getScopeId());
            if (execution != null) {
                processDefinitionId = execution.getProcessDefinitionId();
            }
        } else if ("task".equals(entityLink.getScopeType()) && entityLink.getScopeId() != null && (task = this.processEngineConfiguration.getTaskServiceConfiguration().getTaskService().getTask(entityLink.getScopeId())) != null) {
            processDefinitionId = task.getProcessDefinitionId();
        }
        return processDefinitionId;
    }
}

