/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.flowable.engine.impl.runtime.ProcessInstanceBuilderImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.ProcessInstanceHelper;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.form.api.FormFieldHandler;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.variable.service.impl.el.NoExecutionVariableScope;

public class StartProcessInstanceCmd<T>
implements Command<ProcessInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected String processDefinitionParentDeploymentId;
    protected Map<String, Object> variables;
    protected Map<String, Object> transientVariables;
    protected String businessKey;
    protected String businessStatus;
    protected String tenantId;
    protected String overrideDefinitionTenantId;
    protected String predefinedProcessInstanceId;
    protected String processInstanceName;
    protected String startEventId;
    protected String callbackId;
    protected String callbackType;
    protected String referenceId;
    protected String referenceType;
    protected String ownerId;
    protected String assigneeId;
    protected String stageInstanceId;
    protected Map<String, Object> startFormVariables;
    protected String outcome;
    protected Map<String, Object> extraFormVariables;
    protected FormInfo extraFormInfo;
    protected String extraFormOutcome;
    protected boolean fallbackToDefaultTenant;
    protected ProcessInstanceHelper processInstanceHelper;

    public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey, Map<String, Object> variables) {
        this.processDefinitionKey = processDefinitionKey;
        this.processDefinitionId = processDefinitionId;
        this.businessKey = businessKey;
        this.variables = variables;
    }

    public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey, Map<String, Object> variables, String tenantId) {
        this(processDefinitionKey, processDefinitionId, businessKey, variables);
        this.tenantId = tenantId;
    }

    public StartProcessInstanceCmd(ProcessInstanceBuilderImpl processInstanceBuilder) {
        this(processInstanceBuilder.getProcessDefinitionKey(), processInstanceBuilder.getProcessDefinitionId(), processInstanceBuilder.getBusinessKey(), processInstanceBuilder.getVariables(), processInstanceBuilder.getTenantId());
        this.processDefinitionParentDeploymentId = processInstanceBuilder.getProcessDefinitionParentDeploymentId();
        this.processInstanceName = processInstanceBuilder.getProcessInstanceName();
        this.startEventId = processInstanceBuilder.getStartEventId();
        this.overrideDefinitionTenantId = processInstanceBuilder.getOverrideDefinitionTenantId();
        this.predefinedProcessInstanceId = processInstanceBuilder.getPredefinedProcessInstanceId();
        this.transientVariables = processInstanceBuilder.getTransientVariables();
        this.callbackId = processInstanceBuilder.getCallbackId();
        this.callbackType = processInstanceBuilder.getCallbackType();
        this.referenceId = processInstanceBuilder.getReferenceId();
        this.referenceType = processInstanceBuilder.getReferenceType();
        this.ownerId = processInstanceBuilder.getOwnerId();
        this.assigneeId = processInstanceBuilder.getAssigneeId();
        this.stageInstanceId = processInstanceBuilder.getStageInstanceId();
        this.startFormVariables = processInstanceBuilder.getStartFormVariables();
        this.outcome = processInstanceBuilder.getOutcome();
        this.extraFormVariables = processInstanceBuilder.getExtraFormVariables();
        this.extraFormInfo = processInstanceBuilder.getExtraFormInfo();
        this.extraFormOutcome = processInstanceBuilder.getExtraFormOutcome();
        this.fallbackToDefaultTenant = processInstanceBuilder.isFallbackToDefaultTenant();
        this.businessStatus = processInstanceBuilder.getBusinessStatus();
    }

    public ProcessInstance execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        this.processInstanceHelper = processEngineConfiguration.getProcessInstanceHelper();
        ProcessDefinition processDefinition = this.getProcessDefinition(processEngineConfiguration, commandContext);
        ProcessInstance processInstance = null;
        processInstance = this.hasFormData() ? this.handleProcessInstanceWithForm(commandContext, processDefinition, processEngineConfiguration) : this.startProcessInstance(processDefinition);
        return processInstance;
    }

    protected ProcessInstance handleProcessInstanceWithForm(CommandContext commandContext, ProcessDefinition processDefinition, ProcessEngineConfigurationImpl processEngineConfiguration) {
        FormService formService;
        FormInfo formInfo = null;
        Map processVariables = null;
        if (this.hasStartFormData()) {
            FormRepositoryService formRepositoryService;
            StartEvent startEvent;
            String startFormKey;
            FormService formService2 = CommandContextUtil.getFormService(commandContext);
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinition.getId());
            Process process = bpmnModel.getProcessById(processDefinition.getKey());
            FlowElement startElement = process.getInitialFlowElement();
            if (startElement instanceof StartEvent && StringUtils.isNotEmpty((CharSequence)(startFormKey = (startEvent = (StartEvent)startElement).getFormKey())) && (formInfo = this.resolveFormInfo(startEvent, processDefinition, formRepositoryService = CommandContextUtil.getFormRepositoryService(commandContext), processEngineConfiguration)) != null) {
                if (this.isFormFieldValidationEnabled(processEngineConfiguration, startEvent)) {
                    formService2.validateFormFields(formInfo, this.startFormVariables);
                }
                if ((processVariables = formService2.getVariablesFromFormSubmission(formInfo, this.startFormVariables, this.outcome)) != null) {
                    if (this.variables == null) {
                        this.variables = new HashMap<String, Object>();
                    }
                    this.variables.putAll(processVariables);
                }
            }
        }
        Map extraFormVariables = null;
        if (this.extraFormInfo != null && (extraFormVariables = (formService = CommandContextUtil.getFormService(commandContext)).getVariablesFromFormSubmission(this.extraFormInfo, this.extraFormVariables, this.extraFormOutcome)) != null) {
            if (this.variables == null) {
                this.variables = new HashMap<String, Object>();
            }
            this.variables.putAll(extraFormVariables);
        }
        ProcessInstance processInstance = this.startProcessInstance(processDefinition);
        if (processVariables != null) {
            FormService formService3 = CommandContextUtil.getFormService(commandContext);
            formService3.createFormInstance(this.startFormVariables, formInfo, null, processInstance.getId(), processInstance.getProcessDefinitionId(), processInstance.getTenantId(), this.outcome);
            FormFieldHandler formFieldHandler = processEngineConfiguration.getFormFieldHandler();
            formFieldHandler.handleFormFieldsOnSubmit(formInfo, null, processInstance.getId(), null, null, processVariables, processInstance.getTenantId());
        }
        if (extraFormVariables != null) {
            FormFieldHandler formFieldHandler = processEngineConfiguration.getFormFieldHandler();
            formFieldHandler.handleFormFieldsOnSubmit(this.extraFormInfo, null, processInstance.getId(), null, null, extraFormVariables, processInstance.getTenantId());
        }
        return processInstance;
    }

    protected FormInfo resolveFormInfo(StartEvent startEvent, ProcessDefinition processDefinition, FormRepositoryService formRepositoryService, ProcessEngineConfigurationImpl processEngineConfiguration) {
        FormInfo formInfo;
        String formKey = startEvent.getFormKey();
        if (this.tenantId == null || "".equals(this.tenantId)) {
            if (startEvent.isSameDeployment()) {
                String parentDeploymentId = ProcessDefinitionUtil.getDefinitionDeploymentId(processDefinition, processEngineConfiguration);
                formInfo = formRepositoryService.getFormModelByKeyAndParentDeploymentId(formKey, parentDeploymentId);
            } else {
                formInfo = formRepositoryService.getFormModelByKey(formKey);
            }
        } else if (startEvent.isSameDeployment()) {
            String parentDeploymentId = ProcessDefinitionUtil.getDefinitionDeploymentId(processDefinition, processEngineConfiguration);
            formInfo = formRepositoryService.getFormModelByKeyAndParentDeploymentId(formKey, parentDeploymentId, this.tenantId, processEngineConfiguration.isFallbackToDefaultTenant());
        } else {
            formInfo = formRepositoryService.getFormModelByKey(formKey, this.tenantId, processEngineConfiguration.isFallbackToDefaultTenant());
        }
        return formInfo;
    }

    protected boolean isFormFieldValidationEnabled(ProcessEngineConfigurationImpl processEngineConfiguration, StartEvent startEvent) {
        if (processEngineConfiguration.isFormFieldValidationEnabled()) {
            return TaskHelper.isFormFieldValidationEnabled((VariableContainer)NoExecutionVariableScope.getSharedInstance(), processEngineConfiguration, startEvent.getValidateFormFields());
        }
        return false;
    }

    protected ProcessInstance startProcessInstance(ProcessDefinition processDefinition) {
        return this.processInstanceHelper.createProcessInstance(processDefinition, this.businessKey, this.businessStatus, this.processInstanceName, this.startEventId, this.overrideDefinitionTenantId, this.predefinedProcessInstanceId, this.variables, this.transientVariables, this.callbackId, this.callbackType, this.referenceId, this.referenceType, this.ownerId, this.assigneeId, this.stageInstanceId, true);
    }

    protected boolean hasStartFormData() {
        return this.startFormVariables != null || this.outcome != null;
    }

    protected boolean hasFormData() {
        return this.hasStartFormData() || this.extraFormInfo != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ProcessDefinition getProcessDefinition(ProcessEngineConfigurationImpl processEngineConfiguration, CommandContext commandContext) {
        DeploymentManager deploymentCache = CommandContextUtil.getProcessEngineConfiguration(commandContext).getDeploymentManager();
        ProcessDefinitionEntityManager processDefinitionEntityManager = processEngineConfiguration.getProcessDefinitionEntityManager();
        ProcessDefinition processDefinition = null;
        if (this.processDefinitionId != null) {
            processDefinition = deploymentCache.findDeployedProcessDefinitionById(this.processDefinitionId);
            if (processDefinition != null) return processDefinition;
            throw new FlowableObjectNotFoundException("No process definition found for id = '" + this.processDefinitionId + "'", ProcessDefinition.class);
        }
        if (this.processDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId))) {
            if (this.processDefinitionParentDeploymentId != null) {
                processDefinition = processDefinitionEntityManager.findProcessDefinitionByParentDeploymentAndKey(this.processDefinitionParentDeploymentId, this.processDefinitionKey);
            }
            if (processDefinition == null) {
                processDefinition = processDefinitionEntityManager.findLatestProcessDefinitionByKey(this.processDefinitionKey);
            }
            if (processDefinition != null) return processDefinition;
            throw new FlowableObjectNotFoundException("No process definition found for key '" + this.processDefinitionKey + "'", ProcessDefinition.class);
        }
        if (this.processDefinitionKey == null || this.tenantId == null || "".equals(this.tenantId)) throw new FlowableIllegalArgumentException("processDefinitionKey and processDefinitionId are null");
        if (this.processDefinitionParentDeploymentId != null) {
            processDefinition = processDefinitionEntityManager.findProcessDefinitionByParentDeploymentAndKeyAndTenantId(this.processDefinitionParentDeploymentId, this.processDefinitionKey, this.tenantId);
        }
        if (processDefinition == null) {
            processDefinition = processDefinitionEntityManager.findLatestProcessDefinitionByKeyAndTenantId(this.processDefinitionKey, this.tenantId);
        }
        if (processDefinition != null) return processDefinition;
        if (!this.fallbackToDefaultTenant && !processEngineConfiguration.isFallbackToDefaultTenant()) throw new FlowableObjectNotFoundException("Process definition with key '" + this.processDefinitionKey + "' and tenantId '" + this.tenantId + "' was not found", ProcessDefinition.class);
        String defaultTenant = processEngineConfiguration.getDefaultTenantProvider().getDefaultTenant(this.tenantId, "bpmn", this.processDefinitionKey);
        if (StringUtils.isNotEmpty((CharSequence)defaultTenant)) {
            processDefinition = processDefinitionEntityManager.findLatestProcessDefinitionByKeyAndTenantId(this.processDefinitionKey, defaultTenant);
            if (processDefinition != null) {
                this.overrideDefinitionTenantId = this.tenantId;
            }
        } else {
            processDefinition = processDefinitionEntityManager.findLatestProcessDefinitionByKey(this.processDefinitionKey);
        }
        if (processDefinition != null) return processDefinition;
        throw new FlowableObjectNotFoundException("No process definition found for key '" + this.processDefinitionKey + "'. Fallback to default tenant was also applied.", ProcessDefinition.class);
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }
}

