/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.AbstractEntityManager;
import org.flowable.engine.impl.persistence.entity.AttachmentEntity;
import org.flowable.engine.impl.persistence.entity.AttachmentEntityManager;
import org.flowable.engine.impl.persistence.entity.data.AttachmentDataManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.task.Attachment;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class AttachmentEntityManagerImpl
extends AbstractEntityManager<AttachmentEntity>
implements AttachmentEntityManager {
    protected AttachmentDataManager attachmentDataManager;

    public AttachmentEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, AttachmentDataManager attachmentDataManager) {
        super(processEngineConfiguration);
        this.attachmentDataManager = attachmentDataManager;
    }

    @Override
    protected DataManager<AttachmentEntity> getDataManager() {
        return this.attachmentDataManager;
    }

    @Override
    public List<AttachmentEntity> findAttachmentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return this.attachmentDataManager.findAttachmentsByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<AttachmentEntity> findAttachmentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return this.attachmentDataManager.findAttachmentsByTaskId(taskId);
    }

    @Override
    public void deleteAttachmentsByTaskId(String taskId) {
        TaskEntity task;
        this.checkHistoryEnabled();
        List<AttachmentEntity> attachments = this.findAttachmentsByTaskId(taskId);
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        boolean dispatchEvents = eventDispatcher != null && eventDispatcher.isEnabled();
        String processInstanceId = null;
        String processDefinitionId = null;
        String executionId = null;
        if (dispatchEvents && attachments != null && !attachments.isEmpty() && (task = CommandContextUtil.getTaskService().getTask(taskId)) != null) {
            processDefinitionId = task.getProcessDefinitionId();
            processInstanceId = task.getProcessInstanceId();
            executionId = task.getExecutionId();
        }
        for (Attachment attachment : attachments) {
            String contentId = attachment.getContentId();
            if (contentId != null) {
                this.getByteArrayEntityManager().deleteByteArrayById(contentId);
            }
            this.attachmentDataManager.delete((AttachmentEntity)attachment);
            if (!dispatchEvents) continue;
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, attachment, executionId, processInstanceId, processDefinitionId));
        }
    }

    protected void checkHistoryEnabled() {
        if (!this.getHistoryManager().isHistoryEnabled()) {
            throw new FlowableException("In order to use attachments, history should be enabled");
        }
    }

    public AttachmentDataManager getAttachmentDataManager() {
        return this.attachmentDataManager;
    }

    public void setAttachmentDataManager(AttachmentDataManager attachmentDataManager) {
        this.attachmentDataManager = attachmentDataManager;
    }
}

