/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractNeedsTaskHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.task.service.HistoricTaskService;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;

public class TaskEndedHistoryJsonTransformer
extends AbstractNeedsTaskHistoryJsonTransformer {
    public List<String> getTypes() {
        return Collections.singletonList("task-ended");
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String taskId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"id");
        HistoricTaskService historicTaskService = CommandContextUtil.getHistoricTaskService();
        HistoricTaskInstanceEntity historicTaskInstance = historicTaskService.getHistoricTask(taskId);
        if (historicTaskInstance != null) {
            Date lastUpdateTime = AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"__timeStamp");
            if (historicTaskInstance.getLastUpdateTime() == null || !historicTaskInstance.getLastUpdateTime().after(lastUpdateTime)) {
                historicTaskInstance.setLastUpdateTime(lastUpdateTime);
                historicTaskInstance.setName(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"name"));
                historicTaskInstance.setParentTaskId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"parentTaskId"));
                historicTaskInstance.setDescription(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"description"));
                historicTaskInstance.setOwner(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"owner"));
                historicTaskInstance.setAssignee(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"assignee"));
                if (historicalData.has("createTime")) {
                    historicTaskInstance.setCreateTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"createTime"));
                } else {
                    historicTaskInstance.setCreateTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"startTime"));
                }
                historicTaskInstance.setTaskDefinitionKey(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"taskDefinitionKey"));
                historicTaskInstance.setTaskDefinitionId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"taskDefinitionId"));
                historicTaskInstance.setPriority(AsyncHistoryJsonUtil.getIntegerFromJson((ObjectNode)historicalData, (String)"priority").intValue());
                historicTaskInstance.setDueDate(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"dueDate"));
                historicTaskInstance.setCategory(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"category"));
                historicTaskInstance.setFormKey(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"formKey"));
                historicTaskInstance.setClaimTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"claimTime"));
                historicTaskInstance.setTenantId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"tenantId"));
            }
            Date endTime = AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"endTime");
            historicTaskInstance.setEndTime(endTime);
            historicTaskInstance.setDeleteReason(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"deleteReason"));
            Date startTime = historicTaskInstance.getStartTime();
            if (startTime != null && endTime != null) {
                historicTaskInstance.setDurationInMillis(Long.valueOf(endTime.getTime() - startTime.getTime()));
            }
        } else {
            HistoricActivityInstanceEntity historicActivityInstanceEntity;
            String activityId;
            String executionId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"executionId");
            historicTaskInstance = historicTaskService.createHistoricTask();
            historicTaskInstance.setId(taskId);
            historicTaskInstance.setProcessDefinitionId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processDefinitionId"));
            historicTaskInstance.setProcessInstanceId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processInstanceId"));
            historicTaskInstance.setExecutionId(executionId);
            historicTaskInstance.setName(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"name"));
            historicTaskInstance.setParentTaskId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"parentTaskId"));
            historicTaskInstance.setDescription(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"description"));
            historicTaskInstance.setOwner(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"owner"));
            historicTaskInstance.setAssignee(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"assignee"));
            if (historicalData.has("createTime")) {
                historicTaskInstance.setCreateTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"createTime"));
            } else {
                historicTaskInstance.setCreateTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"startTime"));
            }
            historicTaskInstance.setTaskDefinitionKey(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"taskDefinitionKey"));
            historicTaskInstance.setTaskDefinitionId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"taskDefinitionId"));
            historicTaskInstance.setPriority(AsyncHistoryJsonUtil.getIntegerFromJson((ObjectNode)historicalData, (String)"priority").intValue());
            historicTaskInstance.setDueDate(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"dueDate"));
            historicTaskInstance.setCategory(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"category"));
            historicTaskInstance.setFormKey(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"formKey"));
            historicTaskInstance.setClaimTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"claimTime"));
            historicTaskInstance.setTenantId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"tenantId"));
            historicTaskInstance.setLastUpdateTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"__timeStamp"));
            Date endTime = AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"endTime");
            historicTaskInstance.setEndTime(endTime);
            historicTaskInstance.setDeleteReason(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"deleteReason"));
            Date startTime = historicTaskInstance.getStartTime();
            if (startTime != null && endTime != null) {
                historicTaskInstance.setDurationInMillis(Long.valueOf(endTime.getTime() - startTime.getTime()));
            }
            historicTaskService.insertHistoricTask(historicTaskInstance, true);
            if (StringUtils.isNotEmpty((CharSequence)executionId) && StringUtils.isNotEmpty((CharSequence)(activityId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityId"))) && (historicActivityInstanceEntity = this.findHistoricActivityInstance(commandContext, executionId, activityId)) != null) {
                historicActivityInstanceEntity.setTaskId(taskId);
            }
        }
    }
}

