/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.AbstractAsyncHistoryJobHandler;
import org.flowable.engine.impl.history.async.AsyncHistoryJobNotApplicableException;
import org.flowable.engine.impl.history.async.json.transformer.ActivityEndHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.ActivityFullHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.ActivityStartHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.FormPropertiesSubmittedHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.HistoricDetailVariableUpdateHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.HistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.IdentityLinkCreatedHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.IdentityLinkDeletedHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.ProcessInstanceDeleteHistoryByProcessDefinitionIdJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.ProcessInstanceDeleteHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.ProcessInstanceEndHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.ProcessInstancePropertyChangedHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.ProcessInstanceStartHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.SetProcessDefinitionHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.SubProcessInstanceStartHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.TaskAssigneeChangedHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.TaskCreatedHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.TaskEndedHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.TaskOwnerChangedHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.TaskPropertyChangedHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.UpdateProcessDefinitionCascadeHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.VariableCreatedHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.VariableRemovedHistoryJsonTransformer;
import org.flowable.engine.impl.history.async.json.transformer.VariableUpdatedHistoryJsonTransformer;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHistoryJobHandler
extends AbstractAsyncHistoryJobHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncHistoryJobHandler.class);
    public static final String JOB_TYPE = "async-history";
    protected Map<String, List<HistoryJsonTransformer>> historyJsonTransformers = new HashMap<String, List<HistoryJsonTransformer>>();

    public String getType() {
        return JOB_TYPE;
    }

    public void initDefaultTransformers() {
        this.addHistoryJsonTransformer(new ProcessInstanceStartHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new ProcessInstanceEndHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new ProcessInstanceDeleteHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new ProcessInstanceDeleteHistoryByProcessDefinitionIdJsonTransformer());
        this.addHistoryJsonTransformer(new ProcessInstancePropertyChangedHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new SubProcessInstanceStartHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new SetProcessDefinitionHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new UpdateProcessDefinitionCascadeHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new ActivityStartHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new ActivityEndHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new ActivityFullHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new TaskCreatedHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new TaskEndedHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new TaskPropertyChangedHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new TaskAssigneeChangedHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new TaskOwnerChangedHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new IdentityLinkCreatedHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new IdentityLinkDeletedHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new VariableCreatedHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new VariableUpdatedHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new VariableRemovedHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new HistoricDetailVariableUpdateHistoryJsonTransformer());
        this.addHistoryJsonTransformer(new FormPropertiesSubmittedHistoryJsonTransformer());
    }

    public void addHistoryJsonTransformer(HistoryJsonTransformer historyJsonTransformer) {
        String type = historyJsonTransformer.getType();
        if (!this.historyJsonTransformers.containsKey(type)) {
            this.historyJsonTransformers.put(type, new ArrayList());
        }
        this.historyJsonTransformers.get(historyJsonTransformer.getType()).add(historyJsonTransformer);
    }

    @Override
    protected void processHistoryJson(CommandContext commandContext, HistoryJobEntity job, JsonNode historyNode) {
        List<HistoryJsonTransformer> transformers;
        String type = historyNode.get("type").asText();
        ObjectNode historicalJsonData = (ObjectNode)historyNode.get("data");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Handling async history job (id={}, type={})", (Object)job.getId(), (Object)type);
        }
        if ((transformers = this.historyJsonTransformers.get(type)) != null && !transformers.isEmpty()) {
            for (HistoryJsonTransformer transformer : transformers) {
                if (transformer.isApplicable(historicalJsonData, commandContext)) {
                    transformer.transformJson(job, historicalJsonData, commandContext);
                    continue;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Could not handle history job (id={}) for transformer {}. as it is not applicable. Unacquiring. {}", new Object[]{job.getId(), transformer.getType(), historicalJsonData});
                }
                throw new AsyncHistoryJobNotApplicableException();
            }
        } else {
            LOGGER.debug("Cannot transform history json: no transformers found for type {}", (Object)type);
        }
    }

    public Map<String, List<HistoryJsonTransformer>> getHistoryJsonTransformers() {
        return this.historyJsonTransformers;
    }

    public void setHistoryJsonTransformers(Map<String, List<HistoryJsonTransformer>> historyJsonTransformers) {
        this.historyJsonTransformers = historyJsonTransformers;
    }
}

