/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.Process;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.history.HistoryLevel;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;

public class GetProcessDefinitionHistoryLevelModelCmd
implements Command<HistoryLevel>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public GetProcessDefinitionHistoryLevelModelCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public HistoryLevel execute(CommandContext commandContext) {
        ExtensionElement historyLevelElement;
        String historyLevelValue;
        if (this.processDefinitionId == null) {
            throw new FlowableIllegalArgumentException("processDefinitionId is null");
        }
        HistoryLevel historyLevel = null;
        ProcessDefinition processDefinition = (ProcessDefinition)CommandContextUtil.getProcessDefinitionEntityManager(commandContext).findById(this.processDefinitionId);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.processDefinitionId);
        Process process = bpmnModel.getProcessById(processDefinition.getKey());
        if (process.getExtensionElements().containsKey("historyLevel") && StringUtils.isNotEmpty((CharSequence)(historyLevelValue = (historyLevelElement = (ExtensionElement)((List)process.getExtensionElements().get("historyLevel")).iterator().next()).getElementText()))) {
            try {
                historyLevel = HistoryLevel.getHistoryLevelForKey((String)historyLevelValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (historyLevel == null) {
            historyLevel = CommandContextUtil.getProcessEngineConfiguration(commandContext).getHistoryLevel();
        }
        return historyLevel;
    }
}

