/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.asyncexecutor.message;

import java.util.Date;
import org.flowable.engine.common.impl.cfg.TransactionContext;
import org.flowable.engine.common.impl.cfg.TransactionListener;
import org.flowable.engine.common.impl.cfg.TransactionState;
import org.flowable.engine.common.impl.context.Context;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.AsyncHistorySession;
import org.flowable.job.api.HistoryJob;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.asyncexecutor.DefaultJobManager;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageBasedJobManager
extends DefaultJobManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageBasedJobManager.class);

    public AbstractMessageBasedJobManager() {
        super(null);
    }

    public AbstractMessageBasedJobManager(JobServiceConfiguration jobServiceConfiguration) {
        super(jobServiceConfiguration);
    }

    protected void triggerExecutorIfNeeded(JobEntity jobEntity) {
        this.prepareAndSendMessage((JobInfo)jobEntity);
    }

    public HistoryJobEntity scheduleHistoryJob(HistoryJobEntity historyJobEntity) {
        HistoryJobEntity returnValue = super.scheduleHistoryJob(historyJobEntity);
        this.prepareAndSendMessage((JobInfo)returnValue);
        return returnValue;
    }

    public void unacquire(JobInfo job) {
        if (job instanceof JobInfoEntity) {
            JobInfoEntity jobInfoEntity = (JobInfoEntity)job;
            jobInfoEntity.setLockExpirationTime(new Date(this.jobServiceConfiguration.getClock().getCurrentTime().getTime() + (long)this.jobServiceConfiguration.getAsyncExecutor().getAsyncJobLockTimeInMillis()));
        }
        this.prepareAndSendMessage(job);
    }

    public void unacquireWithDecrementRetries(JobInfo job) {
        if (job instanceof HistoryJob) {
            HistoryJobEntity historyJobEntity = (HistoryJobEntity)job;
            if (historyJobEntity.getRetries() > 0) {
                historyJobEntity.setRetries(historyJobEntity.getRetries() - 1);
                this.unacquire((JobInfo)historyJobEntity);
            } else {
                this.jobServiceConfiguration.getHistoryJobEntityManager().deleteNoCascade(historyJobEntity);
            }
        } else {
            this.unacquire(job);
        }
    }

    protected void prepareAndSendMessage(final JobInfo job) {
        TransactionContext transactionContext = Context.getTransactionContext();
        if (transactionContext != null) {
            Context.getTransactionContext().addTransactionListener(TransactionState.COMMITTED, new TransactionListener(){

                public void execute(CommandContext commandContext) {
                    AbstractMessageBasedJobManager.this.sendMessage(job);
                }
            });
        } else if (job instanceof HistoryJobEntity) {
            CommandContext commandContext = Context.getCommandContext();
            AsyncHistorySession asyncHistorySession = (AsyncHistorySession)commandContext.getSession(AsyncHistorySession.class);
            asyncHistorySession.addAsyncHistoryRunnableAfterCommit(new Runnable(){

                @Override
                public void run() {
                    AbstractMessageBasedJobManager.this.sendMessage(job);
                }
            });
        } else {
            LOGGER.warn("Could not send message for job {}: no transaction context active nor is it a history job", (Object)job.getId());
        }
    }

    protected abstract void sendMessage(JobInfo var1);
}

