/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.util.List;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.persistence.entity.data.DataManager;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.JobQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.CountingExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ByteArrayRef;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.JobEntity;
import org.flowable.engine.impl.persistence.entity.JobEntityManager;
import org.flowable.engine.impl.persistence.entity.JobInfoEntityManagerImpl;
import org.flowable.engine.impl.persistence.entity.data.JobDataManager;
import org.flowable.engine.runtime.Job;

public class JobEntityManagerImpl
extends JobInfoEntityManagerImpl<JobEntity>
implements JobEntityManager {
    protected JobDataManager jobDataManager;

    public JobEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, JobDataManager jobDataManager) {
        super(processEngineConfiguration, jobDataManager);
        this.jobDataManager = jobDataManager;
    }

    @Override
    protected DataManager<JobEntity> getDataManager() {
        return this.jobDataManager;
    }

    @Override
    public boolean insertJobEntity(JobEntity timerJobEntity) {
        return this.doInsert(timerJobEntity, true);
    }

    @Override
    public void insert(JobEntity jobEntity, boolean fireCreateEvent) {
        this.doInsert(jobEntity, fireCreateEvent);
    }

    protected boolean doInsert(JobEntity jobEntity, boolean fireCreateEvent) {
        if (jobEntity.getExecutionId() != null) {
            ExecutionEntity execution = (ExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId());
            if (execution != null) {
                execution.getJobs().add(jobEntity);
                if (execution.getTenantId() != null) {
                    jobEntity.setTenantId(execution.getTenantId());
                }
                if (this.isExecutionRelatedEntityCountEnabled(execution)) {
                    CountingExecutionEntity countingExecutionEntity = (CountingExecutionEntity)((Object)execution);
                    countingExecutionEntity.setJobCount(countingExecutionEntity.getJobCount() + 1);
                }
            } else {
                return false;
            }
        }
        jobEntity.setCreateTime(this.getProcessEngineConfiguration().getClock().getCurrentTime());
        super.insert(jobEntity, fireCreateEvent);
        return true;
    }

    @Override
    public List<Job> findJobsByQueryCriteria(JobQueryImpl jobQuery) {
        return this.jobDataManager.findJobsByQueryCriteria(jobQuery);
    }

    @Override
    public long findJobCountByQueryCriteria(JobQueryImpl jobQuery) {
        return this.jobDataManager.findJobCountByQueryCriteria(jobQuery);
    }

    @Override
    public void delete(JobEntity jobEntity) {
        super.delete(jobEntity);
        this.deleteExceptionByteArrayRef(jobEntity);
        this.removeExecutionLink(jobEntity);
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, this));
        }
    }

    @Override
    public void delete(JobEntity entity, boolean fireDeleteEvent) {
        CountingExecutionEntity executionEntity;
        if (entity.getExecutionId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)this.getExecutionEntityManager().findById(entity.getExecutionId()))) {
            executionEntity.setJobCount(executionEntity.getJobCount() - 1);
        }
        super.delete(entity, fireDeleteEvent);
    }

    protected void removeExecutionLink(JobEntity jobEntity) {
        ExecutionEntity execution;
        if (jobEntity.getExecutionId() != null && (execution = (ExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId())) != null) {
            execution.getJobs().remove(jobEntity);
        }
    }

    protected void deleteExceptionByteArrayRef(JobEntity jobEntity) {
        ByteArrayRef exceptionByteArrayRef = jobEntity.getExceptionByteArrayRef();
        if (exceptionByteArrayRef != null) {
            exceptionByteArrayRef.delete();
        }
    }

    public JobDataManager getJobDataManager() {
        return this.jobDataManager;
    }

    public void setJobDataManager(JobDataManager jobDataManager) {
        this.jobDataManager = jobDataManager;
    }
}

