/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.event;

import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.api.delegate.event.FlowableEventListener;
import org.flowable.common.engine.api.delegate.event.FlowableEventType;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.event.EventDispatchAction;
import org.flowable.common.engine.impl.event.FlowableEventSupport;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class FlowableEventDispatcherImpl
implements FlowableEventDispatcher {
    protected FlowableEventSupport eventSupport = new FlowableEventSupport();
    protected boolean enabled = true;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addEventListener(FlowableEventListener listenerToAdd) {
        this.eventSupport.addEventListener(listenerToAdd);
    }

    public void addEventListener(FlowableEventListener listenerToAdd, FlowableEventType ... types) {
        this.eventSupport.addEventListener(listenerToAdd, types);
    }

    public void removeEventListener(FlowableEventListener listenerToRemove) {
        this.eventSupport.removeEventListener(listenerToRemove);
    }

    public void dispatchEvent(FlowableEvent event, String engineType) {
        AbstractEngineConfiguration engineConfiguration;
        CommandContext commandContext;
        if (this.enabled) {
            this.eventSupport.dispatchEvent(event);
        }
        if ((commandContext = Context.getCommandContext()) != null && (engineConfiguration = commandContext.getEngineConfigurations().get(engineType)) != null && engineConfiguration.getAdditionalEventDispatchActions() != null) {
            for (EventDispatchAction eventDispatchAction : engineConfiguration.getAdditionalEventDispatchActions()) {
                eventDispatchAction.dispatchEvent(commandContext, this.eventSupport, event);
            }
        }
    }

    public FlowableEventSupport getEventSupport() {
        return this.eventSupport;
    }

    public void setEventSupport(FlowableEventSupport eventSupport) {
        this.eventSupport = eventSupport;
    }
}

