/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.lock;

import java.sql.SQLIntegrityConstraintViolationException;
import java.time.Duration;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.common.engine.impl.cfg.TransactionPropagation;
import org.flowable.common.engine.impl.cmd.GetLockValueCmd;
import org.flowable.common.engine.impl.cmd.LockCmd;
import org.flowable.common.engine.impl.cmd.ReleaseLockCmd;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.lock.LockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManagerImpl
implements LockManager {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LockManagerImpl.class);
    protected static final int LOCK_NAME_MAX_LENGTH = 64;
    protected CommandExecutor commandExecutor;
    protected String lockName;
    protected Duration lockPollRate;
    protected String engineType;
    protected CommandConfig lockCommandConfig;
    protected boolean hasAcquiredLock;
    protected Duration lockForceAcquireAfter;

    public LockManagerImpl(CommandExecutor commandExecutor, String lockName, Duration lockPollRate, String engineType) {
        this(commandExecutor, lockName, lockPollRate, null, engineType);
    }

    public LockManagerImpl(CommandExecutor commandExecutor, String lockName, Duration lockPollRate, Duration forceAcquireAfter, String engineType) {
        this.commandExecutor = commandExecutor;
        if (lockName.length() > 64) {
            this.lockName = StringUtils.substring((String)lockName, (int)0, (int)64);
            LOGGER.info("Lock name {} was longer than {} characters. Using abbreviated lock name {}", new Object[]{lockName, 64, this.lockName});
        } else {
            this.lockName = lockName;
        }
        this.lockPollRate = lockPollRate;
        this.engineType = engineType;
        this.lockCommandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
        this.lockForceAcquireAfter = forceAcquireAfter;
    }

    @Override
    public void waitForLock(Duration waitTime) {
        long timeToGiveUp = System.currentTimeMillis() + waitTime.toMillis();
        boolean locked = false;
        while (!locked && System.currentTimeMillis() < timeToGiveUp) {
            locked = this.acquireLock();
            if (locked) continue;
            try {
                Thread.sleep(this.getLockPollRate().toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!locked) {
            String lockValue = this.executeCommand(new GetLockValueCmd(this.lockName, this.engineType));
            throw new FlowableException("Could not acquire lock " + this.lockName + ". Current lock value: " + lockValue);
        }
    }

    @Override
    public boolean acquireLock() {
        return this.acquireLock(this.lockForceAcquireAfter);
    }

    @Override
    public boolean acquireLock(Duration lockForceAcquireAfter) {
        if (this.hasAcquiredLock) {
            return true;
        }
        try {
            this.hasAcquiredLock = this.executeCommand(new LockCmd(this.lockName, lockForceAcquireAfter, this.engineType));
            if (this.hasAcquiredLock) {
                LOGGER.debug("Successfully acquired lock {}", (Object)this.lockName);
            }
        }
        catch (FlowableOptimisticLockingException ex) {
            LOGGER.debug("Failed to acquire lock {} due to optimistic locking", (Object)this.lockName, (Object)ex);
            this.hasAcquiredLock = false;
        }
        catch (FlowableException ex) {
            if (((Object)((Object)ex)).getClass().equals(FlowableException.class)) {
                LOGGER.warn("Failed to acquire lock {} due to unknown exception", (Object)this.lockName, (Object)ex);
                this.hasAcquiredLock = false;
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof SQLIntegrityConstraintViolationException) {
                LOGGER.debug("Failed to acquire lock {} due to constraint violation", (Object)this.lockName, (Object)ex);
            } else {
                LOGGER.info("Failed to acquire lock {} due to unknown exception", (Object)this.lockName, (Object)ex);
            }
            this.hasAcquiredLock = false;
        }
        return this.hasAcquiredLock;
    }

    @Override
    public void releaseLock() {
        this.executeCommand(new ReleaseLockCmd(this.lockName, this.engineType, false));
        LOGGER.debug("successfully released lock {}", (Object)this.lockName);
        this.hasAcquiredLock = false;
    }

    @Override
    public void releaseAndDeleteLock() {
        this.executeCommand(new ReleaseLockCmd(this.lockName, this.engineType, true));
        LOGGER.debug("successfully released and deleted lock {}", (Object)this.lockName);
        this.hasAcquiredLock = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T waitForLockRunAndRelease(Duration waitTime, Supplier<T> supplier) {
        this.waitForLock(waitTime);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.releaseLock();
        }
    }

    protected <T> T executeCommand(Command<T> command) {
        return this.commandExecutor.execute(this.lockCommandConfig, command);
    }

    protected Duration getLockPollRate() {
        return this.lockPollRate;
    }
}

