/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.flowable.common.engine.impl.runtime.Clock;
import org.flowable.common.engine.impl.util.TimeZoneUtil;

public class DefaultClockImpl
implements Clock {
    private TimeZone timeZone;
    protected static volatile Calendar CURRENT_TIME;

    public DefaultClockImpl() {
    }

    public DefaultClockImpl(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public void setCurrentTime(Date currentTime) {
        GregorianCalendar time = null;
        if (currentTime != null) {
            time = this.timeZone == null ? new GregorianCalendar() : new GregorianCalendar(this.timeZone);
            time.setTime(currentTime);
        }
        this.setCurrentCalendar(time);
    }

    @Override
    public void setCurrentCalendar(Calendar currentTime) {
        CURRENT_TIME = currentTime;
    }

    @Override
    public void reset() {
        CURRENT_TIME = null;
    }

    @Override
    public Date getCurrentTime() {
        return CURRENT_TIME == null ? new Date() : CURRENT_TIME.getTime();
    }

    @Override
    public Calendar getCurrentCalendar() {
        if (CURRENT_TIME == null) {
            return this.timeZone == null ? new GregorianCalendar() : new GregorianCalendar(this.timeZone);
        }
        return (Calendar)CURRENT_TIME.clone();
    }

    @Override
    public Calendar getCurrentCalendar(TimeZone timeZone) {
        return TimeZoneUtil.convertToTimeZone(this.getCurrentCalendar(), timeZone);
    }

    @Override
    public TimeZone getCurrentTimeZone() {
        return this.getCurrentCalendar().getTimeZone();
    }
}

