/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.logging;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.logging.LoggingSession;
import org.flowable.common.engine.impl.persistence.StrongUuidGenerator;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class LoggingSessionUtil {
    public static final String ID = "__id";
    public static final String TRANSACTION_ID = "__transactionId";
    public static final String TIMESTAMP = "__timeStamp";
    public static final String LOG_NUMBER = "__logNumber";
    protected static TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
    protected static StrongUuidGenerator idGenerator = new StrongUuidGenerator();

    public static void addLoggingData(String type, String message, String scopeId, String subScopeId, String scopeType, String scopeDefinitionId, String elementId, String elementName, String elementType, String elementSubType) {
        ObjectNode loggingNode = LoggingSessionUtil.fillLoggingData(message, scopeId, subScopeId, scopeType, scopeDefinitionId, elementId, elementName, elementType, elementSubType);
        LoggingSessionUtil.addLoggingData(type, loggingNode);
    }

    public static void addErrorLoggingData(String type, ObjectNode loggingNode, Throwable t) {
        ObjectNode exceptionNode = loggingNode.putObject("exception");
        exceptionNode.put("message", t.getMessage());
        exceptionNode.put("stackTrace", ExceptionUtils.getStackTrace((Throwable)t));
        LoggingSessionUtil.addLoggingData(type, loggingNode);
    }

    public static void addLoggingData(String type, String message) {
        ObjectNode loggingNode = LoggingSessionUtil.getObjectMapper().createObjectNode();
        loggingNode.put("message", message);
        LoggingSessionUtil.addLoggingData(type, loggingNode);
    }

    public static void addEngineLoggingData(String type, String message, String engineType) {
        ObjectNode loggingNode = LoggingSessionUtil.getObjectMapper().createObjectNode();
        loggingNode.put("message", message);
        loggingNode.put("engineType", engineType);
        LoggingSession loggingSession = Context.getCommandContext().getSession(LoggingSession.class);
        List<ObjectNode> loggingData = loggingSession.getLoggingData();
        if (loggingData != null) {
            for (ObjectNode itemNode : loggingData) {
                if (!itemNode.has("scopeId") || !itemNode.has("scopeDefinitionKey")) continue;
                loggingNode.put("scopeId", itemNode.get("scopeId").asText());
                loggingNode.put("scopeType", itemNode.get("scopeType").asText());
                loggingNode.put("scopeDefinitionId", itemNode.get("scopeDefinitionId").asText());
                loggingNode.put("scopeDefinitionKey", itemNode.get("scopeDefinitionKey").asText());
                if (!itemNode.has("scopeDefinitionName") || itemNode.get("scopeDefinitionName").isNull()) continue;
                loggingNode.put("scopeDefinitionName", itemNode.get("scopeDefinitionName").asText());
            }
        }
        LoggingSessionUtil.addLoggingData(type, loggingNode);
    }

    public static void addLoggingData(String type, ObjectNode data) {
        data.put(ID, idGenerator.getNextId());
        data.put(TIMESTAMP, LoggingSessionUtil.formatDate(new Date()));
        data.put("type", type);
        LoggingSession loggingSession = Context.getCommandContext().getSession(LoggingSession.class);
        loggingSession.addLoggingData(type, data);
    }

    public static ObjectNode fillLoggingData(String message, String scopeId, String subScopeId, String scopeType, String scopeDefinitionId, String elementId, String elementName, String elementType, String elementSubType) {
        ObjectNode loggingNode = LoggingSessionUtil.fillLoggingData(message, scopeId, subScopeId, scopeType);
        loggingNode.put("scopeDefinitionId", scopeDefinitionId);
        if (StringUtils.isNotEmpty((CharSequence)elementId)) {
            loggingNode.put("elementId", elementId);
        }
        if (StringUtils.isNotEmpty((CharSequence)elementName)) {
            loggingNode.put("elementName", elementName);
        }
        if (StringUtils.isNotEmpty((CharSequence)elementType)) {
            loggingNode.put("elementType", elementType);
        }
        if (StringUtils.isNotEmpty((CharSequence)elementSubType)) {
            loggingNode.put("elementSubType", elementSubType);
        }
        return loggingNode;
    }

    public static ObjectNode fillLoggingData(String message, String scopeId, String subScopeId, String scopeType) {
        ObjectNode loggingNode = LoggingSessionUtil.getObjectMapper().createObjectNode();
        loggingNode.put("message", message);
        loggingNode.put("scopeId", scopeId);
        if (StringUtils.isNotEmpty((CharSequence)subScopeId)) {
            loggingNode.put("subScopeId", subScopeId);
        }
        loggingNode.put("scopeType", scopeType);
        return loggingNode;
    }

    public static String formatDate(Date date) {
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
            dateFormat.setTimeZone(utcTimeZone);
            return dateFormat.format(date);
        }
        return null;
    }

    public static String formatDate(DateTime date) {
        if (date != null) {
            return date.toString("yyyy-MM-dd'T'hh:mm:ss.sss'Z'");
        }
        return null;
    }

    public static String formatDate(LocalDate date) {
        if (date != null) {
            return date.toString("yyyy-MM-dd");
        }
        return null;
    }

    protected static String getEngineType(CommandContext commandContext) {
        String engineName = null;
        if (commandContext.getCurrentEngineConfiguration().getEngineName() != null) {
            String engineConfigKey = commandContext.getCurrentEngineConfiguration().getEngineCfgKey();
            if ("cfg.processEngine".equals(engineConfigKey)) {
                engineName = "bpmn";
            } else if ("cfg.cmmnEngine".equals(engineConfigKey)) {
                engineName = "cmmn";
            } else if ("cfg.dmnEngine".equals(engineConfigKey)) {
                engineName = "dmn";
            } else if ("cfg.appEngine".equals(engineConfigKey)) {
                engineName = "app";
            } else if ("cfg.formEngine".equals(engineConfigKey)) {
                engineName = "form";
            } else if ("cfg.contentEngine".equals(engineConfigKey)) {
                engineName = "content";
            } else if ("cfg.idmEngine".equals(engineConfigKey)) {
                engineName = "idm";
            }
        }
        return engineName;
    }

    protected static ObjectMapper getObjectMapper() {
        return LoggingSessionUtil.getEngineConfiguration().getObjectMapper();
    }

    protected static AbstractEngineConfiguration getEngineConfiguration() {
        return Context.getCommandContext().getCurrentEngineConfiguration();
    }
}

