/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.logging;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandContextCloseListener;
import org.flowable.common.engine.impl.logging.LoggingListener;
import org.flowable.common.engine.impl.logging.LoggingSession;
import org.flowable.common.engine.impl.logging.LoggingSessionUtil;

public class LoggingSessionCommandContextCloseListener
implements CommandContextCloseListener {
    protected LoggingSession loggingSession;
    protected LoggingListener loggingListener;

    public LoggingSessionCommandContextCloseListener() {
    }

    public LoggingSessionCommandContextCloseListener(LoggingSession loggingSession, LoggingListener loggingListener) {
        this.loggingSession = loggingSession;
        this.loggingListener = loggingListener;
    }

    @Override
    public void closing(CommandContext commandContext) {
    }

    @Override
    public void closed(CommandContext commandContext) {
        String engineType = LoggingSessionUtil.getEngineType(commandContext);
        LoggingSessionUtil.addEngineLoggingData("commandContextClose", "Closed command context for " + engineType + " engine", engineType);
        List<ObjectNode> loggingData = this.loggingSession.getLoggingData();
        this.loggingListener.loggingGenerated(loggingData);
    }

    @Override
    public void closeFailure(CommandContext commandContext) {
        String engineType = LoggingSessionUtil.getEngineType(commandContext);
        LoggingSessionUtil.addEngineLoggingData("commandContextCloseFailure", "Exception at closing command context for " + engineType + " engine", engineType);
        List<ObjectNode> loggingData = this.loggingSession.getLoggingData();
        this.loggingListener.loggingGenerated(loggingData);
    }

    @Override
    public void afterSessionsFlush(CommandContext commandContext) {
    }

    public LoggingSession getLoggingSession() {
        return this.loggingSession;
    }

    public void setLoggingSession(LoggingSession loggingSession) {
        this.loggingSession = loggingSession;
    }

    public LoggingListener getLoggingListener() {
        return this.loggingListener;
    }

    public void setLoggingListener(LoggingListener loggingListener) {
        this.loggingListener = loggingListener;
    }
}

