/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.el.function;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.function.AbstractFlowableShortHandExpressionFunction;

public abstract class AbstractFlowableVariableExpressionFunction
extends AbstractFlowableShortHandExpressionFunction {
    private static final List<String> FUNCTION_PREFIXES = Arrays.asList("variables", "vars", "var");
    private static final String FINAL_FUNCTION_PREFIX = "variables";

    public AbstractFlowableVariableExpressionFunction(String functionName) {
        this(Collections.singletonList(functionName), functionName);
    }

    public AbstractFlowableVariableExpressionFunction(List<String> functionNameOptions, String functionName) {
        super("variableContainer", functionNameOptions, functionName);
    }

    @Override
    protected List<String> getFunctionPrefixOptions() {
        return FUNCTION_PREFIXES;
    }

    @Override
    protected String getFinalFunctionPrefix() {
        return FINAL_FUNCTION_PREFIX;
    }

    @Override
    protected boolean isMultiParameterFunction() {
        return true;
    }

    @Override
    public String prefix() {
        return FINAL_FUNCTION_PREFIX;
    }

    protected static Object getVariableValue(VariableContainer variableContainer, String variableName) {
        if (variableName == null) {
            throw new FlowableIllegalArgumentException("Variable name passed is null");
        }
        return variableContainer.getVariable(variableName);
    }

    protected static boolean valuesAreNumbers(Object variableValue, Object actualValue) {
        return actualValue instanceof Number && variableValue instanceof Number;
    }
}

