/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.el.function;

import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.el.function.FlowableShortHandExpressionFunction;

public abstract class AbstractFlowableShortHandExpressionFunction
implements FlowableShortHandExpressionFunction {
    protected String variableScopeName;
    protected String functionName;
    protected String prefix;
    protected String localName;
    protected Method method;
    protected Pattern pattern;
    protected String replacePattern;

    public AbstractFlowableShortHandExpressionFunction(String variableScopeName, List<String> functionNameOptions, String functionName) {
        List<String> functionPrefixOptions = this.getFunctionPrefixOptions();
        String matchingFunctionPrefix = !functionPrefixOptions.isEmpty() ? this.buildOrWordGroup(functionPrefixOptions) + ":" : "";
        this.pattern = Pattern.compile(matchingFunctionPrefix + this.buildOrWordGroup(functionNameOptions) + "\\s*\\(\\s*'?\"?(.*?)'?\"?\\s*" + (this.isMultiParameterFunction() ? "," : "\\)"));
        this.prefix = this.getFinalFunctionPrefix();
        StringBuilder replacePatternBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)this.prefix)) {
            replacePatternBuilder.append(this.prefix).append(":");
        }
        replacePatternBuilder.append(functionName);
        if (this.isNoParameterMethod()) {
            replacePatternBuilder.append('(').append(variableScopeName);
        } else if (!functionPrefixOptions.isEmpty()) {
            replacePatternBuilder.append('(').append(variableScopeName).append(",'$3'");
        } else {
            replacePatternBuilder.append('(').append(variableScopeName).append(",'$2'");
        }
        if (this.isMultiParameterFunction()) {
            replacePatternBuilder.append(',');
        } else {
            replacePatternBuilder.append(')');
        }
        this.replacePattern = replacePatternBuilder.toString();
        this.localName = functionName;
        this.method = this.findMethod();
    }

    protected Method findMethod() {
        Method[] methods;
        for (Method method : methods = this.getClass().getMethods()) {
            if (!method.getName().equals(this.localName)) continue;
            return method;
        }
        throw new FlowableException("Programmatic error: could not find method " + this.localName + " on class " + this.getClass());
    }

    protected abstract List<String> getFunctionPrefixOptions();

    protected abstract String getFinalFunctionPrefix();

    protected abstract boolean isMultiParameterFunction();

    protected boolean isNoParameterMethod() {
        return false;
    }

    protected String buildOrWordGroup(List<String> options) {
        StringBuilder strb = new StringBuilder();
        strb.append("(");
        strb.append(String.join((CharSequence)"|", options));
        strb.append(")");
        return strb.toString();
    }

    public String enhance(String expressionText) {
        Matcher matcher = this.pattern.matcher(expressionText);
        if (matcher.find()) {
            return matcher.replaceAll(this.replacePattern);
        }
        return expressionText;
    }

    public String localName() {
        return this.localName;
    }

    public String prefix() {
        return this.prefix;
    }

    public Method functionMethod() {
        return this.method;
    }
}

