/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.scripting;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.SimpleScriptContext;
import org.flowable.engine.common.impl.scripting.Resolver;
import org.flowable.variable.api.delegate.VariableScope;

public class ScriptBindings
implements Bindings {
    protected static final Set<String> UNSTORED_KEYS = new HashSet<String>(Arrays.asList("out", "out:print", "lang:import", "context", "elcontext", "print", "println", "nashorn.global"));
    protected List<Resolver> scriptResolvers;
    protected VariableScope variableScope;
    protected Bindings defaultBindings;
    protected boolean storeScriptVariables = true;

    public ScriptBindings(List<Resolver> scriptResolvers, VariableScope variableScope) {
        this.scriptResolvers = scriptResolvers;
        this.variableScope = variableScope;
        this.defaultBindings = new SimpleScriptContext().getBindings(100);
    }

    public ScriptBindings(List<Resolver> scriptResolvers, VariableScope variableScope, boolean storeScriptVariables) {
        this(scriptResolvers, variableScope);
        this.storeScriptVariables = storeScriptVariables;
    }

    @Override
    public boolean containsKey(Object key) {
        for (Resolver scriptResolver : this.scriptResolvers) {
            if (!scriptResolver.containsKey(key)) continue;
            return true;
        }
        return this.defaultBindings.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        for (Resolver scriptResolver : this.scriptResolvers) {
            if (!scriptResolver.containsKey(key)) continue;
            return scriptResolver.get(key);
        }
        return this.defaultBindings.get(key);
    }

    @Override
    public Object put(String name, Object value) {
        if (this.storeScriptVariables) {
            Object oldValue = null;
            if (!UNSTORED_KEYS.contains(name)) {
                oldValue = this.variableScope.getVariable(name);
                this.variableScope.setVariable(name, value);
                return oldValue;
            }
        }
        return this.defaultBindings.put(name, value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.variableScope.getVariables().entrySet();
    }

    @Override
    public Set<String> keySet() {
        return this.variableScope.getVariables().keySet();
    }

    @Override
    public int size() {
        return this.variableScope.getVariables().size();
    }

    @Override
    public Collection<Object> values() {
        return this.variableScope.getVariables().values();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        if (UNSTORED_KEYS.contains(key)) {
            return null;
        }
        return this.defaultBindings.remove(key);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    public void addUnstoredKey(String unstoredKey) {
        UNSTORED_KEYS.add(unstoredKey);
    }
}

