/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.persistence.cache;

import java.util.HashMap;
import org.flowable.engine.common.impl.persistence.entity.Entity;

public class CachedEntity {
    protected Entity entity;
    protected Object originalPersistentState;

    public CachedEntity(Entity entity, boolean storeState) {
        this.entity = entity;
        if (storeState) {
            this.originalPersistentState = entity.getPersistentState();
            entity.setOriginalPersistentState(this.originalPersistentState);
        } else if (entity.getOriginalPersistentState() == null) {
            entity.setOriginalPersistentState(new HashMap(1));
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public Object getOriginalPersistentState() {
        return this.originalPersistentState;
    }

    public void setOriginalPersistentState(Object originalPersistentState) {
        this.originalPersistentState = originalPersistentState;
    }

    public boolean hasChanged() {
        return this.entity.getPersistentState() != null && !this.entity.getPersistentState().equals(this.originalPersistentState);
    }
}

