/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.calendar;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.runtime.ClockReader;
import org.flowable.engine.common.impl.util.TimeZoneUtil;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

public class DurationHelper {
    protected static DateFormat DATE_FORMAT = new SimpleDateFormat("EEE MMM dd kk:mm:ss z yyyy");
    private Calendar start;
    private Calendar end;
    private Duration period;
    private boolean isRepeat;
    private int times;
    private int maxIterations = -1;
    private boolean repeatWithNoBounds;
    private DatatypeFactory datatypeFactory;
    protected ClockReader clockReader;

    public Calendar getStart() {
        return this.start;
    }

    public Calendar getEnd() {
        return this.end;
    }

    public Duration getPeriod() {
        return this.period;
    }

    public boolean isRepeat() {
        return this.isRepeat;
    }

    public int getTimes() {
        return this.times;
    }

    public DurationHelper(String expressionS, int maxIterations, ClockReader clockReader) throws Exception {
        this.clockReader = clockReader;
        this.maxIterations = maxIterations;
        List<String> expression = Arrays.asList(expressionS.split("/"));
        this.datatypeFactory = DatatypeFactory.newInstance();
        if (expression.size() > 3 || expression.isEmpty()) {
            throw new FlowableIllegalArgumentException("Cannot parse duration");
        }
        if (expression.get(0).startsWith("R")) {
            this.isRepeat = true;
            int n = this.times = expression.get(0).length() == 1 ? 0x7FFFFFFE : Integer.parseInt(expression.get(0).substring(1));
            if (expression.get(0).equals("R")) {
                this.repeatWithNoBounds = true;
            }
            expression = expression.subList(1, expression.size());
        }
        if (this.isDuration(expression.get(0))) {
            this.period = this.parsePeriod(expression.get(0));
            this.end = expression.size() == 1 ? null : this.parseDate(expression.get(1));
        } else {
            this.start = this.parseDate(expression.get(0));
            if (this.isDuration(expression.get(1))) {
                this.period = this.parsePeriod(expression.get(1));
            } else {
                this.end = this.parseDate(expression.get(1));
                this.period = this.datatypeFactory.newDuration(this.end.getTimeInMillis() - this.start.getTimeInMillis());
            }
        }
        if (this.start == null) {
            this.start = clockReader.getCurrentCalendar();
        }
    }

    public DurationHelper(String expressionS, ClockReader clockReader) throws Exception {
        this(expressionS, -1, clockReader);
    }

    public Calendar getCalendarAfter() {
        return this.getCalendarAfter(this.clockReader.getCurrentCalendar());
    }

    public Calendar getCalendarAfter(Calendar time) {
        if (this.isRepeat) {
            return this.getDateAfterRepeat(time);
        }
        if (this.end != null) {
            return this.end;
        }
        return this.add(this.start, this.period);
    }

    public Boolean isValidDate(Date newTimer) {
        return this.end == null || this.end.getTime().after(newTimer) || this.end.getTime().equals(newTimer);
    }

    public Date getDateAfter() {
        Calendar date = this.getCalendarAfter();
        return date == null ? null : date.getTime();
    }

    private Calendar getDateAfterRepeat(Calendar date) {
        Calendar current = TimeZoneUtil.convertToTimeZone(this.start, date.getTimeZone());
        if (this.repeatWithNoBounds) {
            Calendar newTime;
            while ((current.before(date) || current.equals(date)) && !(newTime = this.add(current, this.period)).equals(current) && !newTime.before(current)) {
                current = newTime;
            }
        } else {
            int maxLoops = this.times;
            if (this.maxIterations > 0) {
                maxLoops = this.maxIterations - this.times;
            }
            for (int i = 0; i < maxLoops + 1 && !current.after(date); ++i) {
                current = this.add(current, this.period);
            }
        }
        return current.before(date) ? date : TimeZoneUtil.convertToTimeZone(current, this.clockReader.getCurrentTimeZone());
    }

    protected Calendar add(Calendar date, Duration duration) {
        Calendar calendar = (Calendar)date.clone();
        calendar.add(13, duration.getSeconds() * duration.getSign());
        calendar.add(12, duration.getMinutes() * duration.getSign());
        calendar.add(10, duration.getHours() * duration.getSign());
        calendar.add(5, duration.getDays() * duration.getSign());
        calendar.add(2, duration.getMonths() * duration.getSign());
        calendar.add(1, duration.getYears() * duration.getSign());
        return calendar;
    }

    protected Calendar parseDate(String date) throws Exception {
        Calendar dateCalendar = null;
        try {
            dateCalendar = ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.forTimeZone((TimeZone)this.clockReader.getCurrentTimeZone())).parseDateTime(date).toCalendar(null);
        }
        catch (IllegalArgumentException e) {
            dateCalendar = new GregorianCalendar();
            dateCalendar.setTime(DATE_FORMAT.parse(date));
        }
        return dateCalendar;
    }

    protected Duration parsePeriod(String period) throws Exception {
        return this.datatypeFactory.newDuration(period);
    }

    protected boolean isDuration(String time) {
        return time.startsWith("P");
    }
}

