/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.flowable.engine.common.AbstractEngineConfiguration;
import org.flowable.engine.common.AbstractServiceConfiguration;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableOptimisticLockingException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContextCloseListener;
import org.flowable.engine.common.impl.interceptor.Session;
import org.flowable.engine.common.impl.interceptor.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandContext.class);
    protected Map<String, AbstractEngineConfiguration> engineConfigurations;
    protected AbstractEngineConfiguration currentEngineConfiguration;
    protected Map<String, AbstractServiceConfiguration> serviceConfigurations;
    protected Command<?> command;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected Map<Class<?>, Session> sessions = new HashMap();
    protected Throwable exception;
    protected List<CommandContextCloseListener> closeListeners;
    protected Map<String, Object> attributes;
    protected boolean reused;
    protected LinkedList<Object> resultStack = new LinkedList();

    public CommandContext(Command<?> command) {
        this.command = command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        block25: {
            try {
                try {
                    try {
                        this.executeCloseListenersClosing();
                        if (this.exception == null) {
                            this.flushSessions();
                        }
                    }
                    catch (Throwable exception) {
                        try {
                            this.exception(exception);
                            break block25;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                if (this.exception == null) {
                                    this.executeCloseListenersAfterSessionFlushed();
                                }
                            }
                            catch (Throwable exception2) {
                                this.exception(exception2);
                            }
                            if (this.exception != null) {
                                this.logException();
                                this.executeCloseListenersCloseFailure();
                            } else {
                                this.executeCloseListenersClosed();
                            }
                        }
                    }
                    try {
                        if (this.exception == null) {
                            this.executeCloseListenersAfterSessionFlushed();
                        }
                    }
                    catch (Throwable exception) {
                        this.exception(exception);
                    }
                    if (this.exception != null) {
                        this.logException();
                        this.executeCloseListenersCloseFailure();
                    } else {
                        this.executeCloseListenersClosed();
                    }
                }
                catch (Throwable exception) {
                    this.exception(exception);
                }
                finally {
                    this.closeSessions();
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
        if (this.exception == null) return;
        this.rethrowExceptionIfNeeded();
    }

    protected void logException() {
        if (this.exception instanceof FlowableException && !((FlowableException)this.exception).isLogged()) {
            return;
        }
        if (this.exception instanceof FlowableOptimisticLockingException) {
            LOGGER.debug("Optimistic locking exception : {}", (Object)this.exception.getMessage(), (Object)this.exception);
        } else if (this.exception instanceof FlowableException && ((FlowableException)this.exception).isReduceLogLevel()) {
            LOGGER.info("Error while closing command context", this.exception);
        } else {
            LOGGER.error("Error while closing command context", this.exception);
        }
    }

    protected void rethrowExceptionIfNeeded() throws Error {
        if (this.exception instanceof Error) {
            throw (Error)this.exception;
        }
        if (this.exception instanceof RuntimeException) {
            throw (RuntimeException)this.exception;
        }
        throw new FlowableException("exception while executing command " + this.command, this.exception);
    }

    public void addCloseListener(CommandContextCloseListener commandContextCloseListener) {
        if (this.closeListeners == null) {
            this.closeListeners = new ArrayList<CommandContextCloseListener>();
        }
        this.closeListeners.add(commandContextCloseListener);
    }

    public List<CommandContextCloseListener> getCloseListeners() {
        return this.closeListeners;
    }

    protected void executeCloseListenersClosing() {
        if (this.closeListeners != null) {
            try {
                for (CommandContextCloseListener listener : this.closeListeners) {
                    listener.closing(this);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    protected void executeCloseListenersAfterSessionFlushed() {
        if (this.closeListeners != null) {
            try {
                for (CommandContextCloseListener listener : this.closeListeners) {
                    listener.afterSessionsFlush(this);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    protected void executeCloseListenersClosed() {
        if (this.closeListeners != null) {
            try {
                for (CommandContextCloseListener listener : this.closeListeners) {
                    listener.closed(this);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    protected void executeCloseListenersCloseFailure() {
        if (this.closeListeners != null) {
            try {
                for (CommandContextCloseListener listener : this.closeListeners) {
                    listener.closeFailure(this);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    protected void flushSessions() {
        for (Session session : this.sessions.values()) {
            session.flush();
        }
    }

    protected void closeSessions() {
        for (Session session : this.sessions.values()) {
            try {
                session.close();
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    public void exception(Throwable exception) {
        if (this.exception == null) {
            this.exception = exception;
        } else {
            LOGGER.error("masked exception in command context. for root cause, see below as it will be rethrown later.", exception);
        }
    }

    public void addAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(1);
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        if (this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    public <T> T getSession(Class<T> sessionClass) {
        Session session = this.sessions.get(sessionClass);
        if (session == null) {
            SessionFactory sessionFactory = this.sessionFactories.get(sessionClass);
            if (sessionFactory == null) {
                throw new FlowableException("no session factory configured for " + sessionClass.getName());
            }
            session = sessionFactory.openSession(this);
            this.sessions.put(sessionClass, session);
        }
        return (T)session;
    }

    public Map<Class<?>, SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public void setSessionFactories(Map<Class<?>, SessionFactory> sessionFactories) {
        this.sessionFactories = sessionFactories;
    }

    public AbstractEngineConfiguration getCurrentEngineConfiguration() {
        return this.currentEngineConfiguration;
    }

    public void setCurrentEngineConfiguration(AbstractEngineConfiguration currentEngineConfiguration) {
        this.currentEngineConfiguration = currentEngineConfiguration;
    }

    public Map<String, AbstractEngineConfiguration> getEngineConfigurations() {
        return this.engineConfigurations;
    }

    public void setEngineConfigurations(Map<String, AbstractEngineConfiguration> engineConfigurations) {
        this.engineConfigurations = engineConfigurations;
    }

    public void addEngineConfiguration(String engineKey, AbstractEngineConfiguration engineConfiguration) {
        if (this.engineConfigurations == null) {
            this.engineConfigurations = new HashMap<String, AbstractEngineConfiguration>();
        }
        this.engineConfigurations.put(engineKey, engineConfiguration);
    }

    public Map<String, AbstractServiceConfiguration> getServiceConfigurations() {
        return this.serviceConfigurations;
    }

    public void setServiceConfigurations(Map<String, AbstractServiceConfiguration> serviceConfigurations) {
        this.serviceConfigurations = serviceConfigurations;
    }

    public Command<?> getCommand() {
        return this.command;
    }

    public Map<Class<?>, Session> getSessions() {
        return this.sessions;
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean isReused() {
        return this.reused;
    }

    public void setReused(boolean reused) {
        this.reused = reused;
    }

    public Object getResult() {
        return this.resultStack.pollLast();
    }

    public void setResult(Object result) {
        this.resultStack.add(result);
    }
}

