/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.xml.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.io.InputStreamProvider;
import org.flowable.dmn.converter.util.DmnXMLUtil;
import org.flowable.dmn.model.BuiltinAggregator;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionRule;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.DecisionTable;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.model.DmnElement;
import org.flowable.dmn.model.DmnElementReference;
import org.flowable.dmn.model.DmnExtensionAttribute;
import org.flowable.dmn.model.DmnExtensionElement;
import org.flowable.dmn.model.Expression;
import org.flowable.dmn.model.HitPolicy;
import org.flowable.dmn.model.InformationItem;
import org.flowable.dmn.model.InformationRequirement;
import org.flowable.dmn.model.InputClause;
import org.flowable.dmn.model.InputData;
import org.flowable.dmn.model.ItemDefinition;
import org.flowable.dmn.model.RuleInputClauseContainer;
import org.flowable.dmn.xml.constants.DmnXMLConstants;
import org.flowable.dmn.xml.converter.AuthorityRequirementConverter;
import org.flowable.dmn.xml.converter.BaseDmnXMLConverter;
import org.flowable.dmn.xml.converter.ConversionHelper;
import org.flowable.dmn.xml.converter.DMNDIExport;
import org.flowable.dmn.xml.converter.DecisionRuleXMLConverter;
import org.flowable.dmn.xml.converter.DecisionServiceXMLConverter;
import org.flowable.dmn.xml.converter.DmnDiBoundsXmlConverter;
import org.flowable.dmn.xml.converter.DmnDiDecisionServiceDividerLineXmlConverter;
import org.flowable.dmn.xml.converter.DmnDiDiagramXmlConverter;
import org.flowable.dmn.xml.converter.DmnDiEdgeXmlConverter;
import org.flowable.dmn.xml.converter.DmnDiShapeXmlConverter;
import org.flowable.dmn.xml.converter.DmnDiSizeXmlConverter;
import org.flowable.dmn.xml.converter.DmnDiWaypointXmlConverter;
import org.flowable.dmn.xml.converter.IndentingXMLStreamWriter;
import org.flowable.dmn.xml.converter.InformationRequirementConverter;
import org.flowable.dmn.xml.converter.InputClauseXMLConverter;
import org.flowable.dmn.xml.converter.InputDataXMLConverter;
import org.flowable.dmn.xml.converter.ItemDefinitionXMLConverter;
import org.flowable.dmn.xml.converter.OutputClauseXMLConverter;
import org.flowable.dmn.xml.converter.VariableXMLConverter;
import org.flowable.dmn.xml.exception.DmnXMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DmnXMLConverter
implements DmnXMLConstants {
    protected static final Set<String> defaultNamespaces = new HashSet<String>(Arrays.asList("xsi", "dmndi", "dc", "di"));
    protected static final Logger LOGGER = LoggerFactory.getLogger(DmnXMLConverter.class);
    protected static final String DMN_XSD = "org/flowable/impl/dmn/parser/DMN13.xsd";
    protected static final String DMN_11_XSD = "org/flowable/impl/dmn/parser/dmn.xsd";
    protected static final String DMN_12_XSD = "org/flowable/impl/dmn/parser/DMN12.xsd";
    protected static final String DMN_12_TARGET_NAMESPACE = "http://www.omg.org/spec/DMN/20180521/MODEL/";
    protected static final String DMN_13_TARGET_NAMESPACE = "https://www.omg.org/spec/DMN/20191111/MODEL/";
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected static final Collection<DmnExtensionAttribute> KNOWN_DEFINITION_ATTRIBUTES = Arrays.asList(new DmnExtensionAttribute("id"), new DmnExtensionAttribute("name"), new DmnExtensionAttribute("exporter"), new DmnExtensionAttribute("exporterVersion"), new DmnExtensionAttribute("namespace"));
    protected static final Collection<DmnExtensionAttribute> KNOWN_DECISION_ATTRIBUTES = Arrays.asList(new DmnExtensionAttribute("http://flowable.org/dmn", "forceDMN11"), new DmnExtensionAttribute("id"), new DmnExtensionAttribute("name"));
    protected static Map<String, BaseDmnXMLConverter> convertersToDmnMap = new HashMap<String, BaseDmnXMLConverter>();
    protected ClassLoader classloader;

    public static void addConverter(BaseDmnXMLConverter converter) {
        convertersToDmnMap.put(converter.getXMLElementName(), converter);
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public void validateModel(InputStreamProvider inputStreamProvider) throws Exception {
        String targetNameSpace = this.getTargetNameSpace(inputStreamProvider.getInputStream());
        Schema schema = DMN_13_TARGET_NAMESPACE.equals(targetNameSpace) ? this.createSchema(DMN_XSD) : (DMN_12_TARGET_NAMESPACE.equals(targetNameSpace) ? this.createSchema(DMN_12_XSD) : this.createSchema(DMN_11_XSD));
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(inputStreamProvider.getInputStream()));
    }

    public void validateModel(XMLStreamReader xmlStreamReader) throws Exception {
        String targetNameSpace = this.getTargetNameSpace(xmlStreamReader);
        Schema schema = DMN_13_TARGET_NAMESPACE.equals(targetNameSpace) ? this.createSchema(DMN_XSD) : (DMN_12_TARGET_NAMESPACE.equals(targetNameSpace) ? this.createSchema(DMN_12_XSD) : this.createSchema(DMN_11_XSD));
        Validator validator = schema.newValidator();
        validator.validate(new StAXSource(xmlStreamReader));
    }

    protected String getTargetNameSpace(InputStream is) {
        try {
            XMLInputFactory xif = XMLInputFactory.newInstance();
            XMLStreamReader xtr = xif.createXMLStreamReader(is);
            return this.getTargetNameSpace(xtr);
        }
        catch (XMLStreamException e) {
            LOGGER.error("Error processing DMN document", (Throwable)e);
            throw new DmnXMLException("Error processing DMN document", e);
        }
    }

    protected String getTargetNameSpace(XMLStreamReader xmlStreamReader) {
        String targetNameSpace;
        block4: {
            targetNameSpace = null;
            try {
                if (!xmlStreamReader.hasNext()) break block4;
                try {
                    xmlStreamReader.next();
                }
                catch (Exception e) {
                    LOGGER.debug("Error reading XML document", (Throwable)e);
                    throw new DmnXMLException("Error reading XML", e);
                }
                targetNameSpace = xmlStreamReader.getNamespaceURI();
            }
            catch (XMLStreamException e) {
                LOGGER.error("Error processing DMN document", (Throwable)e);
                throw new DmnXMLException("Error processing DMN document", e);
            }
        }
        return targetNameSpace;
    }

    protected Schema createSchema(String xsd) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        if (this.classloader != null) {
            schema = factory.newSchema(this.classloader.getResource(xsd));
        }
        if (schema == null) {
            schema = factory.newSchema(this.getClass().getClassLoader().getResource(xsd));
        }
        if (schema == null) {
            throw new DmnXMLException("DMN XSD could not be found");
        }
        return schema;
    }

    public DmnDefinition convertToDmnModel(InputStreamProvider inputStreamProvider, boolean validateSchema, boolean enableSafeDmnXml) {
        return this.convertToDmnModel(inputStreamProvider, validateSchema, enableSafeDmnXml, DEFAULT_ENCODING);
    }

    public DmnDefinition convertToDmnModel(InputStreamProvider inputStreamProvider, boolean validateSchema, boolean enableSafeDmnXml, String encoding) {
        DmnDefinition dmnDefinition;
        InputStreamReader in;
        XMLInputFactory xif = XMLInputFactory.newInstance();
        if (xif.isPropertySupported("javax.xml.stream.isReplacingEntityReferences")) {
            xif.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        }
        if (xif.isPropertySupported("javax.xml.stream.isSupportingExternalEntities")) {
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        if (xif.isPropertySupported("javax.xml.stream.supportDTD")) {
            xif.setProperty("javax.xml.stream.supportDTD", false);
        }
        if (validateSchema) {
            try {
                in = new InputStreamReader(inputStreamProvider.getInputStream(), encoding);
                try {
                    if (!enableSafeDmnXml) {
                        this.validateModel(inputStreamProvider);
                    } else {
                        this.validateModel(xif.createXMLStreamReader(in));
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new DmnXMLException("The dmn xml is not properly encoded", e);
            }
            catch (XMLStreamException e) {
                throw new DmnXMLException("Error while reading the dmn xml file", e);
            }
            catch (Exception e) {
                throw new DmnXMLException(e.getMessage(), e);
            }
        }
        in = new InputStreamReader(inputStreamProvider.getInputStream(), encoding);
        try {
            dmnDefinition = this.convertToDmnModel(xif.createXMLStreamReader(in));
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedEncodingException e) {
                throw new DmnXMLException("The dmn xml is not properly encoded", e);
            }
            catch (XMLStreamException e) {
                throw new DmnXMLException("Error while reading the dmn xml file", e);
            }
            catch (IOException e) {
                throw new DmnXMLException(e.getMessage(), e);
            }
        }
        in.close();
        return dmnDefinition;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DmnDefinition convertToDmnModel(XMLStreamReader xtr) {
        DmnDefinition model = new DmnDefinition();
        DecisionTable parentElement = null;
        Decision currentDecision = null;
        DecisionTable currentDecisionTable = null;
        ConversionHelper conversionHelper = new ConversionHelper();
        conversionHelper.setDmnDefinition(model);
        try {
            block5: while (xtr.hasNext()) {
                try {
                    xtr.next();
                }
                catch (Exception e) {
                    LOGGER.debug("Error reading XML document", (Throwable)e);
                    throw new DmnXMLException("Error reading XML", e);
                }
                if (!xtr.isStartElement()) continue;
                if ("definitions".equals(xtr.getLocalName())) {
                    model.setId(xtr.getAttributeValue(null, "id"));
                    model.setName(xtr.getAttributeValue(null, "name"));
                    model.setExporter(xtr.getAttributeValue(null, "exporter"));
                    model.setExporterVersion(xtr.getAttributeValue(null, "exporterVersion"));
                    model.setNamespace("http://www.flowable.org/dmn");
                    for (int i = 0; i < xtr.getNamespaceCount(); ++i) {
                        String prefix = xtr.getNamespacePrefix(i);
                        if (!StringUtils.isNotEmpty((CharSequence)prefix)) continue;
                        model.addNamespace(prefix, xtr.getNamespaceURI(i));
                    }
                    DmnXMLUtil.parseAttributes((DmnElement)model, xtr, KNOWN_DEFINITION_ATTRIBUTES);
                    parentElement = model;
                    continue;
                }
                if ("decision".equals(xtr.getLocalName())) {
                    convertersToDmnMap.get("rule").initializeElementCounter();
                    convertersToDmnMap.get("input").initializeElementCounter();
                    convertersToDmnMap.get("output").initializeElementCounter();
                    currentDecision = new Decision();
                    currentDecision.setDmnDefinition(model);
                    model.addDecision(currentDecision);
                    currentDecision.setId(xtr.getAttributeValue(null, "id"));
                    currentDecision.setName(xtr.getAttributeValue(null, "name"));
                    if (Boolean.parseBoolean(xtr.getAttributeValue("http://flowable.org/dmn", "forceDMN11"))) {
                        currentDecision.setForceDMN11(true);
                    }
                    DmnXMLUtil.parseAttributes((DmnElement)currentDecision, xtr, KNOWN_DECISION_ATTRIBUTES);
                    parentElement = currentDecision;
                    conversionHelper.setCurrentDecision(currentDecision);
                    continue;
                }
                if ("decisionTable".equals(xtr.getLocalName())) {
                    currentDecisionTable = new DecisionTable();
                    currentDecisionTable.setId(xtr.getAttributeValue(null, "id"));
                    if (xtr.getAttributeValue(null, "hitPolicy") != null) {
                        currentDecisionTable.setHitPolicy(HitPolicy.get((String)xtr.getAttributeValue(null, "hitPolicy")));
                    } else {
                        currentDecisionTable.setHitPolicy(HitPolicy.FIRST);
                    }
                    if (xtr.getAttributeValue(null, "aggregation") != null) {
                        currentDecisionTable.setAggregation(BuiltinAggregator.get((String)xtr.getAttributeValue(null, "aggregation")));
                    }
                    currentDecision.setExpression((Expression)currentDecisionTable);
                    parentElement = currentDecisionTable;
                    continue;
                }
                if ("description".equals(xtr.getLocalName())) {
                    parentElement.setDescription(StringUtils.abbreviate((String)xtr.getElementText(), (int)255));
                    continue;
                }
                if (!"extensionElements".equals(xtr.getLocalName())) {
                    if (!convertersToDmnMap.containsKey(xtr.getLocalName())) continue;
                    BaseDmnXMLConverter converter = convertersToDmnMap.get(xtr.getLocalName());
                    converter.convertToDmnModel(xtr, conversionHelper);
                    continue;
                }
                while (xtr.hasNext()) {
                    xtr.next();
                    if (xtr.isStartElement()) {
                        DmnExtensionElement extensionElement = DmnXMLUtil.parseExtensionElement(xtr);
                        parentElement.addExtensionElement(extensionElement);
                        continue;
                    }
                    if (!xtr.isEndElement() || !"extensionElements".equals(xtr.getLocalName())) continue;
                    continue block5;
                }
            }
        }
        catch (DmnXMLException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Error processing DMN document", (Throwable)e);
            throw new DmnXMLException("Error processing DMN document", e);
        }
        this.processDiElements(conversionHelper);
        return model;
    }

    protected void processDiElements(ConversionHelper conversionHelper) {
        DmnDefinition dmnDefinition = conversionHelper.getDmnDefinition();
        conversionHelper.getDiDiagrams().forEach(diDiagram -> {
            dmnDefinition.addDiDiagram(diDiagram);
            if (conversionHelper.getDiShapes(diDiagram.getId()) != null) {
                conversionHelper.getDiShapes(diDiagram.getId()).forEach(dmnDiShape -> {
                    dmnDefinition.addGraphicInfoByDiagramId(diDiagram.getId(), dmnDiShape.getDmnElementRef(), dmnDiShape.getGraphicInfo());
                    if (dmnDiShape.getDecisionServiceDividerLine() != null) {
                        dmnDefinition.addDecisionServiceDividerGraphicInfoListByDiagramId(diDiagram.getId(), dmnDiShape.getDmnElementRef(), dmnDiShape.getDecisionServiceDividerLine().getWaypoints());
                    }
                });
            }
            if (conversionHelper.getDiEdges(diDiagram.getId()) != null) {
                conversionHelper.getDiEdges(diDiagram.getId()).forEach(dmnDiEdge -> {
                    if (dmnDiEdge.getId() != null) {
                        dmnDefinition.addFlowGraphicInfoListByDiagramId(diDiagram.getId(), dmnDiEdge.getDmnElementRef(), dmnDiEdge.getWaypoints());
                    }
                });
            }
        });
    }

    public byte[] convertToXML(DmnDefinition model) {
        return this.convertToXML(model, DEFAULT_ENCODING);
    }

    public byte[] convertToXML(DmnDefinition model, String encoding) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream, encoding);
            XMLStreamWriter writer = xof.createXMLStreamWriter(out);
            IndentingXMLStreamWriter xtw = new IndentingXMLStreamWriter(writer);
            xtw.writeStartElement("definitions");
            xtw.writeDefaultNamespace(DMN_13_TARGET_NAMESPACE);
            xtw.writeNamespace("dmndi", "https://www.omg.org/spec/DMN/20191111/DMNDI/");
            xtw.writeNamespace("dc", "http://www.omg.org/spec/DMN/20180521/DC/");
            xtw.writeNamespace("di", "http://www.omg.org/spec/DMN/20180521/DI/");
            for (Map.Entry entry : model.getNamespaces().entrySet()) {
                if (defaultNamespaces.contains(entry.getKey())) continue;
                xtw.writeNamespace((String)entry.getKey(), (String)entry.getValue());
            }
            xtw.writeAttribute("id", model.getId());
            if (StringUtils.isNotEmpty((CharSequence)model.getName())) {
                xtw.writeAttribute("name", model.getName());
            }
            xtw.writeAttribute("namespace", "http://www.flowable.org/dmn");
            if (StringUtils.isNotEmpty((CharSequence)model.getExporter())) {
                xtw.writeAttribute("exporter", model.getExporter());
            }
            if (StringUtils.isNotEmpty((CharSequence)model.getExporterVersion())) {
                xtw.writeAttribute("exporterVersion", model.getExporterVersion());
            }
            DmnXMLUtil.writeAttributes((DmnElement)model, model.getNamespaces(), xtw);
            DmnXMLUtil.writeElementDescription((DmnElement)model, xtw);
            DmnXMLUtil.writeExtensionElements((DmnElement)model, model.getNamespaces(), (XMLStreamWriter)xtw);
            for (InputData inputData : model.getInputData()) {
                xtw.writeStartElement("inputData");
                xtw.writeAttribute("id", inputData.getId());
                if (StringUtils.isNotEmpty((CharSequence)inputData.getName())) {
                    xtw.writeAttribute("name", inputData.getName());
                }
                if (inputData.getVariable() != null) {
                    InformationItem variable = inputData.getVariable();
                    xtw.writeStartElement("variable");
                    xtw.writeAttribute("id", variable.getId());
                    xtw.writeAttribute("typeRef", variable.getTypeRef());
                    if (StringUtils.isNotEmpty((CharSequence)variable.getName())) {
                        xtw.writeAttribute("name", variable.getName());
                    }
                    xtw.writeEndElement();
                }
                DmnXMLUtil.writeElementDescription((DmnElement)inputData, xtw);
                DmnXMLUtil.writeExtensionElements((DmnElement)inputData, model.getNamespaces(), (XMLStreamWriter)xtw);
                xtw.writeEndElement();
            }
            this.writeItemDefinition(model.getItemDefinitions(), model, xtw);
            for (Decision decision : model.getDecisions()) {
                xtw.writeStartElement("decision");
                xtw.writeAttribute("id", decision.getId());
                if (StringUtils.isNotEmpty((CharSequence)decision.getName())) {
                    xtw.writeAttribute("name", decision.getName());
                }
                if (decision.isForceDMN11()) {
                    if (!model.getNamespaces().containsKey("flowable")) {
                        xtw.writeNamespace("flowable", "http://flowable.org/dmn");
                    }
                    xtw.writeAttribute("flowable", "http://flowable.org/dmn", "forceDMN11", "true");
                }
                DmnXMLUtil.writeAttributes((DmnElement)decision, model.getNamespaces(), xtw);
                DmnXMLUtil.writeElementDescription((DmnElement)decision, xtw);
                DmnXMLUtil.writeExtensionElements((DmnElement)decision, model.getNamespaces(), (XMLStreamWriter)xtw);
                if (decision.getVariable() != null) {
                    xtw.writeStartElement("variable");
                    if (StringUtils.isNotEmpty((CharSequence)decision.getVariable().getId())) {
                        xtw.writeAttribute("id", decision.getVariable().getId());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)decision.getVariable().getName())) {
                        xtw.writeAttribute("name", decision.getVariable().getName());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)decision.getVariable().getTypeRef())) {
                        xtw.writeAttribute("typeRef", decision.getVariable().getTypeRef());
                    }
                    xtw.writeEndElement();
                }
                for (InformationRequirement informationRequirement : decision.getRequiredDecisions()) {
                    xtw.writeStartElement("informationRequirement");
                    xtw.writeAttribute("id", informationRequirement.getId());
                    if (informationRequirement.getRequiredDecision() != null) {
                        xtw.writeStartElement("requiredDecision");
                        xtw.writeAttribute("href", informationRequirement.getRequiredDecision().getHref());
                        xtw.writeEndElement();
                    }
                    xtw.writeEndElement();
                }
                for (InformationRequirement informationRequirement : decision.getRequiredInputs()) {
                    xtw.writeStartElement("informationRequirement");
                    xtw.writeAttribute("id", informationRequirement.getId());
                    if (informationRequirement.getRequiredInput() != null) {
                        xtw.writeStartElement("requiredInput");
                        xtw.writeAttribute("href", informationRequirement.getRequiredInput().getHref());
                        xtw.writeEndElement();
                    }
                    xtw.writeEndElement();
                }
                for (Object authorityRequirement : decision.getAuthorityRequirements()) {
                    xtw.writeStartElement("authorityRequirement");
                    xtw.writeAttribute("id", authorityRequirement.getId());
                    if (authorityRequirement.getRequiredAuthority() != null) {
                        xtw.writeStartElement("requiredAuthority");
                        xtw.writeAttribute("href", authorityRequirement.getRequiredAuthority().getHref());
                        xtw.writeEndElement();
                    }
                    xtw.writeEndElement();
                }
                if (decision.getExpression() != null) {
                    Object authorityRequirement;
                    DecisionTable decisionTable = (DecisionTable)decision.getExpression();
                    xtw.writeStartElement("decisionTable");
                    xtw.writeAttribute("id", decisionTable.getId());
                    if (decisionTable.getHitPolicy() != null) {
                        xtw.writeAttribute("hitPolicy", decisionTable.getHitPolicy().getValue());
                    }
                    if (decisionTable.getAggregation() != null) {
                        xtw.writeAttribute("aggregation", decisionTable.getAggregation().toString());
                    }
                    DmnXMLUtil.writeElementDescription((DmnElement)decisionTable, xtw);
                    DmnXMLUtil.writeExtensionElements((DmnElement)decisionTable, model.getNamespaces(), (XMLStreamWriter)xtw);
                    for (InputClause clause : decisionTable.getInputs()) {
                        xtw.writeStartElement("input");
                        if (StringUtils.isNotEmpty((CharSequence)clause.getId())) {
                            xtw.writeAttribute("id", clause.getId());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)clause.getLabel())) {
                            xtw.writeAttribute("label", clause.getLabel());
                        }
                        DmnXMLUtil.writeElementDescription((DmnElement)clause, xtw);
                        DmnXMLUtil.writeExtensionElements((DmnElement)clause, model.getNamespaces(), (XMLStreamWriter)xtw);
                        if (clause.getInputExpression() != null) {
                            xtw.writeStartElement("inputExpression");
                            if (StringUtils.isNotEmpty((CharSequence)clause.getInputExpression().getId())) {
                                xtw.writeAttribute("id", clause.getInputExpression().getId());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)clause.getInputExpression().getTypeRef())) {
                                xtw.writeAttribute("typeRef", clause.getInputExpression().getTypeRef());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)clause.getInputExpression().getText())) {
                                xtw.writeStartElement("text");
                                xtw.writeCharacters(clause.getInputExpression().getText());
                                xtw.writeEndElement();
                            }
                            xtw.writeEndElement();
                        }
                        if (clause.getInputValues() != null && StringUtils.isNotEmpty((CharSequence)clause.getInputValues().getText())) {
                            xtw.writeStartElement("inputValues");
                            xtw.writeStartElement("text");
                            xtw.writeCharacters(clause.getInputValues().getText());
                            xtw.writeEndElement();
                            xtw.writeEndElement();
                        }
                        xtw.writeEndElement();
                    }
                    for (InputClause clause : decisionTable.getOutputs()) {
                        xtw.writeStartElement("output");
                        if (StringUtils.isNotEmpty((CharSequence)clause.getId())) {
                            xtw.writeAttribute("id", clause.getId());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)clause.getLabel())) {
                            xtw.writeAttribute("label", clause.getLabel());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)clause.getName())) {
                            xtw.writeAttribute("name", clause.getName());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)clause.getTypeRef())) {
                            xtw.writeAttribute("typeRef", clause.getTypeRef());
                        }
                        if (clause.getOutputValues() != null && StringUtils.isNotEmpty((CharSequence)clause.getOutputValues().getText())) {
                            xtw.writeStartElement("outputValues");
                            xtw.writeStartElement("text");
                            xtw.writeCharacters(clause.getOutputValues().getText());
                            xtw.writeEndElement();
                            xtw.writeEndElement();
                        }
                        DmnXMLUtil.writeElementDescription((DmnElement)clause, xtw);
                        DmnXMLUtil.writeExtensionElements((DmnElement)clause, model.getNamespaces(), (XMLStreamWriter)xtw);
                        xtw.writeEndElement();
                    }
                    authorityRequirement = decisionTable.getRules().iterator();
                    while (authorityRequirement.hasNext()) {
                        DecisionRule rule = (DecisionRule)authorityRequirement.next();
                        xtw.writeStartElement("rule");
                        if (StringUtils.isNotEmpty((CharSequence)rule.getId())) {
                            xtw.writeAttribute("id", rule.getId());
                        }
                        DmnXMLUtil.writeElementDescription((DmnElement)rule, xtw);
                        DmnXMLUtil.writeExtensionElements((DmnElement)rule, model.getNamespaces(), (XMLStreamWriter)xtw);
                        for (RuleInputClauseContainer container : rule.getInputEntries()) {
                            xtw.writeStartElement("inputEntry");
                            xtw.writeAttribute("id", container.getInputEntry().getId());
                            DmnXMLUtil.writeExtensionElements((DmnElement)container.getInputEntry(), model.getNamespaces(), (XMLStreamWriter)xtw);
                            if (StringUtils.isNotEmpty((CharSequence)container.getInputEntry().getText())) {
                                xtw.writeStartElement("text");
                                xtw.writeCData(container.getInputEntry().getText());
                                xtw.writeEndElement();
                            }
                            xtw.writeEndElement();
                        }
                        for (RuleInputClauseContainer container : rule.getOutputEntries()) {
                            xtw.writeStartElement("outputEntry");
                            xtw.writeAttribute("id", container.getOutputEntry().getId());
                            if (StringUtils.isNotEmpty((CharSequence)container.getOutputEntry().getText())) {
                                xtw.writeStartElement("text");
                                xtw.writeCData(container.getOutputEntry().getText());
                                xtw.writeEndElement();
                            }
                            xtw.writeEndElement();
                        }
                        xtw.writeEndElement();
                    }
                    xtw.writeEndElement();
                }
                xtw.writeEndElement();
            }
            for (DecisionService decisionService : model.getDecisionServices()) {
                xtw.writeStartElement("decisionService");
                xtw.writeAttribute("id", decisionService.getId());
                if (StringUtils.isNotEmpty((CharSequence)decisionService.getName())) {
                    xtw.writeAttribute("name", decisionService.getName());
                }
                for (DmnElementReference reference : decisionService.getOutputDecisions()) {
                    xtw.writeStartElement("outputDecision");
                    xtw.writeAttribute("href", reference.getHref());
                    xtw.writeEndElement();
                }
                for (DmnElementReference reference : decisionService.getEncapsulatedDecisions()) {
                    xtw.writeStartElement("encapsulatedDecision");
                    xtw.writeAttribute("href", reference.getHref());
                    xtw.writeEndElement();
                }
                for (DmnElementReference reference : decisionService.getInputData()) {
                    xtw.writeStartElement("inputData");
                    xtw.writeAttribute("href", reference.getHref());
                    xtw.writeEndElement();
                }
                xtw.writeEndElement();
            }
            DMNDIExport.writeDMNDI(model, xtw);
            xtw.writeEndElement();
            xtw.writeEndDocument();
            xtw.flush();
            outputStream.close();
            xtw.close();
            return outputStream.toByteArray();
        }
        catch (Exception e) {
            LOGGER.error("Error writing DMN XML", (Throwable)e);
            throw new DmnXMLException("Error writing DMN XML", e);
        }
    }

    protected void writeItemDefinition(List<ItemDefinition> itemDefinitions, DmnDefinition model, XMLStreamWriter xtw) throws Exception {
        this.writeItemDefinition(itemDefinitions, false, model, xtw);
    }

    protected void writeItemDefinition(List<ItemDefinition> itemDefinitions, boolean isItemComponent, DmnDefinition model, XMLStreamWriter xtw) throws Exception {
        if (itemDefinitions == null) {
            return;
        }
        for (ItemDefinition itemDefinition : itemDefinitions) {
            if (isItemComponent) {
                xtw.writeStartElement("itemComponent");
            } else {
                xtw.writeStartElement("itemDefinition");
            }
            if (StringUtils.isNotEmpty((CharSequence)itemDefinition.getId())) {
                xtw.writeAttribute("id", itemDefinition.getId());
            }
            if (StringUtils.isNotEmpty((CharSequence)itemDefinition.getName())) {
                xtw.writeAttribute("name", itemDefinition.getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)itemDefinition.getLabel())) {
                xtw.writeAttribute("label", itemDefinition.getLabel());
            }
            if (itemDefinition.isCollection()) {
                xtw.writeAttribute("isCollection", "true");
            }
            DmnXMLUtil.writeElementDescription((DmnElement)itemDefinition, xtw);
            DmnXMLUtil.writeExtensionElements((DmnElement)itemDefinition, model.getNamespaces(), xtw);
            if (itemDefinition.getTypeRef() != null) {
                xtw.writeStartElement("typeRef");
                xtw.writeCharacters(itemDefinition.getTypeRef());
                xtw.writeEndElement();
            }
            if (itemDefinition.getAllowedValues() != null) {
                xtw.writeStartElement("requiredAuthority");
                xtw.writeStartElement("text");
                xtw.writeCharacters(itemDefinition.getAllowedValues().getText());
                xtw.writeEndElement();
                xtw.writeEndElement();
            }
            if (itemDefinition.getItemComponents().size() > 0) {
                this.writeItemDefinition(itemDefinition.getItemComponents(), true, model, xtw);
            }
            xtw.writeEndElement();
        }
    }

    static {
        DmnXMLConverter.addConverter(new InputClauseXMLConverter());
        DmnXMLConverter.addConverter(new OutputClauseXMLConverter());
        DmnXMLConverter.addConverter(new DecisionRuleXMLConverter());
        DmnXMLConverter.addConverter(new InformationRequirementConverter());
        DmnXMLConverter.addConverter(new AuthorityRequirementConverter());
        DmnXMLConverter.addConverter(new ItemDefinitionXMLConverter());
        DmnXMLConverter.addConverter(new InputDataXMLConverter());
        DmnXMLConverter.addConverter(new VariableXMLConverter());
        DmnXMLConverter.addConverter(new DecisionServiceXMLConverter());
        DmnXMLConverter.addConverter(new DmnDiDiagramXmlConverter());
        DmnXMLConverter.addConverter(new DmnDiShapeXmlConverter());
        DmnXMLConverter.addConverter(new DmnDiBoundsXmlConverter());
        DmnXMLConverter.addConverter(new DmnDiEdgeXmlConverter());
        DmnXMLConverter.addConverter(new DmnDiWaypointXmlConverter());
        DmnXMLConverter.addConverter(new DmnDiSizeXmlConverter());
        DmnXMLConverter.addConverter(new DmnDiDecisionServiceDividerLineXmlConverter());
    }
}

