/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.xml.converter;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.model.DmnElement;
import org.flowable.dmn.model.DmnElementReference;
import org.flowable.dmn.xml.converter.BaseDmnXMLConverter;
import org.flowable.dmn.xml.converter.ConversionHelper;

public class DecisionServiceXMLConverter
extends BaseDmnXMLConverter {
    @Override
    protected String getXMLElementName() {
        return "decisionService";
    }

    @Override
    protected DmnElement convertXMLToElement(XMLStreamReader xtr, ConversionHelper conversionHelper) throws Exception {
        DecisionService decisionService = new DecisionService();
        decisionService.setId(xtr.getAttributeValue(null, "id"));
        decisionService.setName(xtr.getAttributeValue(null, "name"));
        decisionService.setLabel(xtr.getAttributeValue(null, "label"));
        boolean readyWithDecisionService = false;
        try {
            while (!readyWithDecisionService && xtr.hasNext()) {
                DmnElementReference ref;
                xtr.next();
                if (xtr.isStartElement() && "outputDecision".equalsIgnoreCase(xtr.getLocalName())) {
                    ref = new DmnElementReference();
                    ref.setHref(xtr.getAttributeValue(null, "href"));
                    decisionService.addOutputDecision(ref);
                }
                if (xtr.isStartElement() && "encapsulatedDecision".equalsIgnoreCase(xtr.getLocalName())) {
                    ref = new DmnElementReference();
                    ref.setHref(xtr.getAttributeValue(null, "href"));
                    decisionService.addEncapsulatedDecision(ref);
                }
                if (xtr.isStartElement() && "inputData".equalsIgnoreCase(xtr.getLocalName())) {
                    ref = new DmnElementReference();
                    ref.setHref(xtr.getAttributeValue(null, "href"));
                    decisionService.addInputData(ref);
                    continue;
                }
                if (!xtr.isEndElement() || !this.getXMLElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
                readyWithDecisionService = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing output entry", (Throwable)e);
        }
        return decisionService;
    }

    @Override
    protected void writeAdditionalAttributes(DmnElement element, DmnDefinition model, XMLStreamWriter xtw) throws Exception {
    }

    @Override
    protected void writeAdditionalChildElements(DmnElement element, DmnDefinition model, XMLStreamWriter xtw) throws Exception {
    }
}

