/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.xml.converter;

import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.model.DmnDiDiagram;
import org.flowable.dmn.model.GraphicInfo;
import org.flowable.dmn.xml.constants.DmnXMLConstants;

public class DMNDIExport
implements DmnXMLConstants {
    public static void writeDMNDI(DmnDefinition model, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("dmndi", "DMNDI", "https://www.omg.org/spec/DMN/20191111/DMNDI/");
        for (Map.Entry diagramEntry : model.getLocationByDiagramIdMap().entrySet()) {
            DmnDiDiagram diDiagram = model.getDiDiagram((String)diagramEntry.getKey());
            Map graphicInfoMap = (Map)diagramEntry.getValue();
            xtw.writeStartElement("dmndi", "DMNDiagram", "https://www.omg.org/spec/DMN/20191111/DMNDI/");
            xtw.writeAttribute("id", diDiagram.getId());
            if (StringUtils.isNotEmpty((CharSequence)diDiagram.getName())) {
                xtw.writeAttribute("name", diDiagram.getName());
            }
            if (diDiagram.getGraphicInfo() != null) {
                xtw.writeStartElement("dmndi", "Size", "https://www.omg.org/spec/DMN/20191111/DMNDI/");
                xtw.writeAttribute("height", String.valueOf(diDiagram.getGraphicInfo().getHeight()));
                xtw.writeAttribute("width", String.valueOf(diDiagram.getGraphicInfo().getWidth()));
                xtw.writeEndElement();
            }
            for (Map.Entry graphicInfoEntry : graphicInfoMap.entrySet()) {
                xtw.writeStartElement("dmndi", "DMNShape", "https://www.omg.org/spec/DMN/20191111/DMNDI/");
                xtw.writeAttribute("id", "DMNShape_" + (String)graphicInfoEntry.getKey());
                xtw.writeAttribute("dmnElementRef", (String)graphicInfoEntry.getKey());
                DMNDIExport.createDmnShapeBounds((GraphicInfo)graphicInfoEntry.getValue(), xtw);
                if (model.getDecisionServiceDividerLocationMapByDiagramId(diDiagram.getId()) != null && model.getDecisionServiceDividerLocationMapByDiagramId(diDiagram.getId()).containsKey(graphicInfoEntry.getKey())) {
                    DMNDIExport.createDmnDecisionServiceDividerLine((List)model.getDecisionServiceDividerLocationMapByDiagramId(diDiagram.getId()).get(graphicInfoEntry.getKey()), xtw);
                }
                xtw.writeEndElement();
            }
            Map flowLocationGraphicInfoMap = model.getFlowLocationMapByDiagramId(diDiagram.getId());
            if (flowLocationGraphicInfoMap != null) {
                for (Map.Entry flowLocationGraphicInfoEntry : flowLocationGraphicInfoMap.entrySet()) {
                    DMNDIExport.createDmnEdge((String)flowLocationGraphicInfoEntry.getKey(), (List)flowLocationGraphicInfoEntry.getValue(), xtw);
                }
            }
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected static void createDmnShapeBounds(GraphicInfo graphicInfo, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("dc", "Bounds", "http://www.omg.org/spec/DMN/20180521/DC/");
        xtw.writeAttribute("height", String.valueOf(graphicInfo.getHeight()));
        xtw.writeAttribute("width", String.valueOf(graphicInfo.getWidth()));
        xtw.writeAttribute("x", String.valueOf(graphicInfo.getX()));
        xtw.writeAttribute("y", String.valueOf(graphicInfo.getY()));
        xtw.writeEndElement();
    }

    protected static void createDmnDecisionServiceDividerLine(List<GraphicInfo> graphicInfoList, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("dmndi", "DMNDecisionServiceDividerLine", "https://www.omg.org/spec/DMN/20191111/DMNDI/");
        for (GraphicInfo graphicInfo : graphicInfoList) {
            xtw.writeStartElement("di", "waypoint", "http://www.omg.org/spec/DMN/20180521/DI/");
            xtw.writeAttribute("x", String.valueOf(graphicInfo.getX()));
            xtw.writeAttribute("y", String.valueOf(graphicInfo.getY()));
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected static void createDmnEdge(String elementId, List<GraphicInfo> graphicInfoList, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("dmndi", "DMNEdge", "https://www.omg.org/spec/DMN/20191111/DMNDI/");
        xtw.writeAttribute("id", "DMNEdge_" + elementId);
        xtw.writeAttribute("dmnElementRef", elementId);
        for (GraphicInfo graphicInfo : graphicInfoList) {
            xtw.writeStartElement("di", "waypoint", "http://www.omg.org/spec/DMN/20180521/DI/");
            xtw.writeAttribute("x", String.valueOf(graphicInfo.getX()));
            xtw.writeAttribute("y", String.valueOf(graphicInfo.getY()));
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }
}

