/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api;

import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class DmnRestUrlBuilder {
    protected String baseUrl = "";

    protected DmnRestUrlBuilder() {
    }

    protected DmnRestUrlBuilder(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String buildUrl(String[] fragments, Object ... arguments) {
        return this.baseUrl + "/" + MessageFormat.format(StringUtils.join((Object[])fragments, (char)'/'), arguments);
    }

    public static DmnRestUrlBuilder usingBaseUrl(String baseUrl) {
        if (baseUrl == null) {
            throw new FlowableIllegalArgumentException("baseUrl can not be null");
        }
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return new DmnRestUrlBuilder(baseUrl);
    }

    public static DmnRestUrlBuilder fromRequest(HttpServletRequest request) {
        return DmnRestUrlBuilder.usingBaseUrl(ServletUriComponentsBuilder.fromServletMapping((HttpServletRequest)request).build().toUriString());
    }

    public static DmnRestUrlBuilder fromCurrentRequest() {
        return DmnRestUrlBuilder.usingBaseUrl(ServletUriComponentsBuilder.fromCurrentServletMapping().build().toUriString());
    }
}

