/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.decision;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.rest.variable.EngineRestVariable;
import org.flowable.dmn.api.DmnDecisionService;
import org.flowable.dmn.api.ExecuteDecisionBuilder;
import org.flowable.dmn.rest.service.api.DmnRestApiInterceptor;
import org.flowable.dmn.rest.service.api.DmnRestResponseFactory;
import org.flowable.dmn.rest.service.api.decision.DmnRuleServiceRequest;
import org.flowable.dmn.rest.service.api.decision.DmnRuleServiceResponse;
import org.flowable.dmn.rest.service.api.decision.DmnRuleServiceSingleResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"DMN Rule Service"}, description="Execute DMN Decision", authorizations={@Authorization(value="basicAuth")})
public class DmnRuleServiceResource {
    @Autowired
    protected DmnRestResponseFactory dmnRestResponseFactory;
    @Autowired
    protected DmnDecisionService dmnRuleService;
    @Autowired(required=false)
    protected DmnRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="Execute a Decision", tags={"DMN Rule Service"})
    @ApiResponses(value={@ApiResponse(code=201, message="Indicates the Decision has been executed")})
    @PostMapping(value={"/dmn-rule/execute"}, produces={"application/json"})
    public DmnRuleServiceResponse executeDecision(@ApiParam(value="request") @RequestBody DmnRuleServiceRequest request, HttpServletRequest httpRequest, HttpServletResponse response) {
        if (request.getDecisionKey() == null) {
            throw new FlowableIllegalArgumentException("Decision key is required.");
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.executeDecisionTable(request);
        }
        Map<String, Object> inputVariables = this.composeInputVariables(request.getInputVariables());
        try {
            ExecuteDecisionBuilder decisionBuilder = this.dmnRuleService.createExecuteDecisionBuilder();
            decisionBuilder.decisionKey(request.getDecisionKey()).variables(inputVariables);
            if (StringUtils.isNotEmpty((CharSequence)request.getParentDeploymentId())) {
                decisionBuilder.parentDeploymentId(request.getParentDeploymentId());
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getTenantId())) {
                decisionBuilder.tenantId(request.getTenantId());
            }
            List executionResult = decisionBuilder.execute();
            response.setStatus(HttpStatus.CREATED.value());
            return this.dmnRestResponseFactory.createDmnRuleServiceResponse(executionResult);
        }
        catch (FlowableObjectNotFoundException fonfe) {
            throw new FlowableIllegalArgumentException(fonfe.getMessage(), (Throwable)fonfe);
        }
    }

    @ApiOperation(value="Execute a Decision expecting a single result", tags={"DMN Rule Service"})
    @ApiResponses(value={@ApiResponse(code=201, message="Indicates the Decision has been executed"), @ApiResponse(code=500, message="Indicates the Decision returned multiple results")})
    @PostMapping(value={"/dmn-rule/execute/single-result"}, produces={"application/json"})
    public DmnRuleServiceSingleResponse executeDecisionByKeySingleResult(@ApiParam(value="request") @RequestBody DmnRuleServiceRequest request, HttpServletRequest httpRequest, HttpServletResponse response) {
        if (request.getDecisionKey() == null) {
            throw new FlowableIllegalArgumentException("Decision key is required.");
        }
        Map<String, Object> inputVariables = this.composeInputVariables(request.getInputVariables());
        try {
            ExecuteDecisionBuilder decisionBuilder = this.dmnRuleService.createExecuteDecisionBuilder();
            decisionBuilder.decisionKey(request.getDecisionKey()).variables(inputVariables);
            if (StringUtils.isNotEmpty((CharSequence)request.getParentDeploymentId())) {
                decisionBuilder.parentDeploymentId(request.getParentDeploymentId());
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getTenantId())) {
                decisionBuilder.tenantId(request.getTenantId());
            }
            Map executionResult = decisionBuilder.executeWithSingleResult();
            response.setStatus(HttpStatus.CREATED.value());
            return this.dmnRestResponseFactory.createDmnRuleServiceResponse(executionResult);
        }
        catch (FlowableObjectNotFoundException fonfe) {
            throw new FlowableIllegalArgumentException(fonfe.getMessage(), (Throwable)fonfe);
        }
    }

    protected Map<String, Object> composeInputVariables(List<EngineRestVariable> restVariables) {
        HashMap<String, Object> inputVariables = null;
        if (restVariables != null) {
            inputVariables = new HashMap<String, Object>();
            for (EngineRestVariable variable : restVariables) {
                if (variable.getName() == null) {
                    throw new FlowableIllegalArgumentException("Variable name is required.");
                }
                inputVariables.put(variable.getName(), this.dmnRestResponseFactory.getVariableValue(variable));
            }
        }
        return inputVariables;
    }
}

