/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.test;

import java.util.ArrayList;
import java.util.List;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.test.EnsureCleanDbUtils;
import org.flowable.dmn.api.DmnDecisionService;
import org.flowable.dmn.api.DmnHistoryService;
import org.flowable.dmn.api.DmnManagementService;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.test.AbstractDmnTestCase;
import org.flowable.dmn.engine.test.DmnTestHelper;
import org.slf4j.Logger;

public abstract class AbstractFlowableDmnTestCase
extends AbstractDmnTestCase {
    private static final List<String> TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK = new ArrayList<String>();
    protected DmnEngine dmnEngine;
    protected String deploymentIdFromDeploymentAnnotation;
    protected List<String> deploymentIdsForAutoCleanup = new ArrayList<String>();
    protected Throwable exception;
    protected DmnEngineConfiguration dmnEngineConfiguration;
    protected DmnManagementService managementService;
    protected DmnRepositoryService repositoryService;
    protected DmnDecisionService ruleService;
    protected DmnHistoryService historyService;

    protected abstract void initializeDmnEngine();

    protected void closeDownDmnEngine() {
    }

    protected void nullifyServices() {
        this.dmnEngineConfiguration = null;
        this.managementService = null;
        this.repositoryService = null;
        this.ruleService = null;
        this.historyService = null;
    }

    public void runBare() throws Throwable {
        this.initializeDmnEngine();
        if (this.repositoryService == null) {
            this.initializeServices();
        }
        try {
            this.deploymentIdFromDeploymentAnnotation = DmnTestHelper.annotationDeploymentSetUp(this.dmnEngine, ((Object)((Object)this)).getClass(), this.getName());
            super.runBare();
        }
        catch (AssertionError e) {
            LOGGER.error("\n");
            LOGGER.error("ASSERTION FAILED: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        catch (Throwable e) {
            LOGGER.error("\n");
            LOGGER.error("EXCEPTION: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        finally {
            if (this.deploymentIdFromDeploymentAnnotation != null) {
                DmnTestHelper.annotationDeploymentTearDown(this.dmnEngine, this.deploymentIdFromDeploymentAnnotation, ((Object)((Object)this)).getClass(), this.getName());
                this.deploymentIdFromDeploymentAnnotation = null;
            }
            for (String autoDeletedDeploymentId : this.deploymentIdsForAutoCleanup) {
                this.repositoryService.deleteDeployment(autoDeletedDeploymentId);
            }
            this.deploymentIdsForAutoCleanup.clear();
            this.assertAndEnsureCleanDb();
            this.dmnEngineConfiguration.getClock().reset();
            this.closeDownDmnEngine();
        }
    }

    protected void assertAndEnsureCleanDb() throws Throwable {
        EnsureCleanDbUtils.assertAndEnsureCleanDb((String)this.getName(), (Logger)LOGGER, (AbstractEngineConfiguration)this.dmnEngineConfiguration, TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK, (this.exception == null ? 1 : 0) != 0, null);
    }

    protected void initializeServices() {
        this.dmnEngineConfiguration = this.dmnEngine.getDmnEngineConfiguration();
        this.managementService = this.dmnEngine.getDmnManagementService();
        this.repositoryService = this.dmnEngine.getDmnRepositoryService();
        this.ruleService = this.dmnEngine.getDmnDecisionService();
        this.historyService = this.dmnEngine.getDmnHistoryService();
    }

    static {
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.add("ACT_DMN_DATABASECHANGELOG");
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.add("ACT_DMN_DATABASECHANGELOGLOCK");
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.add("ACT_GE_PROPERTY");
    }
}

