/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.persistence.entity.AbstractEngineEntityManager;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.dmn.api.DmnDecision;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.DmnDeploymentQueryImpl;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntityManager;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntityManager;
import org.flowable.dmn.engine.impl.persistence.entity.DmnResourceEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnResourceEntityManager;
import org.flowable.dmn.engine.impl.persistence.entity.HistoricDecisionExecutionEntityManager;
import org.flowable.dmn.engine.impl.persistence.entity.data.DmnDeploymentDataManager;

public class DmnDeploymentEntityManagerImpl
extends AbstractEngineEntityManager<DmnEngineConfiguration, DmnDeploymentEntity, DmnDeploymentDataManager>
implements DmnDeploymentEntityManager {
    public DmnDeploymentEntityManagerImpl(DmnEngineConfiguration dmnEngineConfiguration, DmnDeploymentDataManager deploymentDataManager) {
        super((AbstractEngineConfiguration)dmnEngineConfiguration, (DataManager)deploymentDataManager);
    }

    public void insert(DmnDeploymentEntity deployment) {
        super.insert((Entity)deployment, true);
        for (EngineResource resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceEntityManager().insert((DmnResourceEntity)resource);
        }
    }

    @Override
    public void deleteDeployment(String deploymentId) {
        this.getHistoricDecisionExecutionEntityManager().deleteHistoricDecisionExecutionsByDeploymentId(deploymentId);
        this.getDecisionTableEntityManager().deleteDecisionsByDeploymentId(deploymentId);
        this.getResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.delete((DmnDeploymentEntity)this.findById(deploymentId));
    }

    protected DecisionEntity findLatestDefinition(DmnDecision definition) {
        DecisionEntity latestDefinition = null;
        latestDefinition = definition.getTenantId() != null && !"".equals(definition.getTenantId()) ? this.getDecisionTableEntityManager().findLatestDecisionByKeyAndTenantId(definition.getKey(), definition.getTenantId()) : this.getDecisionTableEntityManager().findLatestDecisionByKey(definition.getKey());
        return latestDefinition;
    }

    @Override
    public long findDeploymentCountByQueryCriteria(DmnDeploymentQueryImpl deploymentQuery) {
        return ((DmnDeploymentDataManager)this.dataManager).findDeploymentCountByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<DmnDeployment> findDeploymentsByQueryCriteria(DmnDeploymentQueryImpl deploymentQuery) {
        return ((DmnDeploymentDataManager)this.dataManager).findDeploymentsByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return ((DmnDeploymentDataManager)this.dataManager).getDeploymentResourceNames(deploymentId);
    }

    @Override
    public List<DmnDeployment> findDeploymentsByNativeQuery(Map<String, Object> parameterMap) {
        return ((DmnDeploymentDataManager)this.dataManager).findDeploymentsByNativeQuery(parameterMap);
    }

    @Override
    public long findDeploymentCountByNativeQuery(Map<String, Object> parameterMap) {
        return ((DmnDeploymentDataManager)this.dataManager).findDeploymentCountByNativeQuery(parameterMap);
    }

    protected DmnResourceEntityManager getResourceEntityManager() {
        return ((DmnEngineConfiguration)this.engineConfiguration).getResourceEntityManager();
    }

    protected HistoricDecisionExecutionEntityManager getHistoricDecisionExecutionEntityManager() {
        return ((DmnEngineConfiguration)this.engineConfiguration).getHistoricDecisionExecutionEntityManager();
    }

    protected DecisionEntityManager getDecisionTableEntityManager() {
        return ((DmnEngineConfiguration)this.engineConfiguration).getDecisionEntityManager();
    }
}

