/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.api.ExecuteDecisionContext;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.DmnDeploymentQueryImpl;
import org.flowable.dmn.engine.impl.ExecuteDecisionBuilderImpl;
import org.flowable.dmn.engine.impl.persistence.deploy.DecisionCacheEntry;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntityManager;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.model.DmnElement;

public abstract class AbstractExecuteDecisionCmd
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected ExecuteDecisionContext executeDecisionContext;

    public AbstractExecuteDecisionCmd(ExecuteDecisionContext executeDecisionContext) {
        this.executeDecisionContext = executeDecisionContext;
    }

    public AbstractExecuteDecisionCmd(ExecuteDecisionBuilderImpl definitionBuilder) {
        this.executeDecisionContext = new ExecuteDecisionContext();
        this.executeDecisionContext.setDecisionKey(definitionBuilder.getDecisionKey());
        this.executeDecisionContext.setParentDeploymentId(definitionBuilder.getParentDeploymentId());
        this.executeDecisionContext.setInstanceId(definitionBuilder.getInstanceId());
        this.executeDecisionContext.setExecutionId(definitionBuilder.getExecutionId());
        this.executeDecisionContext.setActivityId(definitionBuilder.getActivityId());
        this.executeDecisionContext.setScopeType(definitionBuilder.getScopeType());
        this.executeDecisionContext.setVariables(definitionBuilder.getVariables());
        this.executeDecisionContext.setTenantId(definitionBuilder.getTenantId());
        this.executeDecisionContext.setFallbackToDefaultTenant(definitionBuilder.isFallbackToDefaultTenant());
    }

    public AbstractExecuteDecisionCmd(String decisionKey, Map<String, Object> variables) {
        this.executeDecisionContext = new ExecuteDecisionContext();
        this.executeDecisionContext.setDecisionKey(decisionKey);
        this.executeDecisionContext.setVariables(variables);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DmnDefinition resolveDefinition() {
        List<DmnDeployment> dmnDeployments;
        DecisionEntity decision = null;
        DmnEngineConfiguration dmnEngineConfiguration = CommandContextUtil.getDmnEngineConfiguration();
        DecisionEntityManager decisionEntityManager = dmnEngineConfiguration.getDecisionEntityManager();
        String decisionKey = this.executeDecisionContext.getDecisionKey();
        String parentDeploymentId = this.executeDecisionContext.getParentDeploymentId();
        String tenantId = this.executeDecisionContext.getTenantId();
        if (StringUtils.isNotEmpty((CharSequence)decisionKey) && StringUtils.isNotEmpty((CharSequence)parentDeploymentId) && !dmnEngineConfiguration.isAlwaysLookupLatestDefinitionVersion() && StringUtils.isNotEmpty((CharSequence)tenantId)) {
            dmnDeployments = CommandContextUtil.getDeploymentEntityManager().findDeploymentsByQueryCriteria(new DmnDeploymentQueryImpl().parentDeploymentId(parentDeploymentId));
            if (dmnDeployments != null && dmnDeployments.size() != 0) {
                decision = decisionEntityManager.findDecisionByDeploymentAndKeyAndTenantId(dmnDeployments.get(0).getId(), decisionKey, tenantId);
            }
            if (decision == null && (decision = decisionEntityManager.findLatestDecisionByKeyAndTenantId(decisionKey, tenantId)) == null) {
                String defaultTenant;
                if (!this.executeDecisionContext.isFallbackToDefaultTenant()) {
                    if (!dmnEngineConfiguration.isFallbackToDefaultTenant()) throw new FlowableObjectNotFoundException("No decision found for key: " + decisionKey + ", parent deployment id " + parentDeploymentId + " and tenant id: " + tenantId + ". There was also no fall back decision found without parent deployment id.");
                }
                if (StringUtils.isNotEmpty((CharSequence)(defaultTenant = dmnEngineConfiguration.getDefaultTenantProvider().getDefaultTenant(tenantId, "dmn", decisionKey)))) {
                    decision = decisionEntityManager.findLatestDecisionByKeyAndTenantId(decisionKey, defaultTenant);
                    if (decision == null) {
                        throw new FlowableObjectNotFoundException("No decision found for key: " + decisionKey + ". There was also no fall back decision found for default tenant " + defaultTenant);
                    }
                } else {
                    decision = decisionEntityManager.findLatestDecisionByKey(decisionKey);
                    if (decision == null) {
                        throw new FlowableObjectNotFoundException("No decision found for key: " + decisionKey + ". There was also no fall back decision table found without tenant.");
                    }
                }
            }
        } else if (StringUtils.isNotEmpty((CharSequence)decisionKey) && StringUtils.isNotEmpty((CharSequence)parentDeploymentId) && !dmnEngineConfiguration.isAlwaysLookupLatestDefinitionVersion()) {
            dmnDeployments = CommandContextUtil.getDeploymentEntityManager().findDeploymentsByQueryCriteria(new DmnDeploymentQueryImpl().parentDeploymentId(parentDeploymentId));
            if (dmnDeployments != null && dmnDeployments.size() != 0) {
                decision = decisionEntityManager.findDecisionByDeploymentAndKey(dmnDeployments.get(0).getId(), decisionKey);
            }
            if (decision == null && (decision = decisionEntityManager.findLatestDecisionByKey(decisionKey)) == null) {
                throw new FlowableObjectNotFoundException("No decision found for key: " + decisionKey + " and parent deployment id " + parentDeploymentId + ". There was also no fall back decision found without parent deployment id.");
            }
        } else if (StringUtils.isNotEmpty((CharSequence)decisionKey) && StringUtils.isNotEmpty((CharSequence)tenantId)) {
            decision = decisionEntityManager.findLatestDecisionByKeyAndTenantId(decisionKey, tenantId);
            if (decision == null) {
                String defaultTenant;
                if (!this.executeDecisionContext.isFallbackToDefaultTenant()) {
                    if (!dmnEngineConfiguration.isFallbackToDefaultTenant()) throw new FlowableObjectNotFoundException("No decision found for key: " + decisionKey + " and tenantId: " + tenantId + ".");
                }
                if (StringUtils.isNotEmpty((CharSequence)(defaultTenant = dmnEngineConfiguration.getDefaultTenantProvider().getDefaultTenant(tenantId, "dmn", decisionKey)))) {
                    decision = decisionEntityManager.findLatestDecisionByKeyAndTenantId(decisionKey, defaultTenant);
                    if (decision == null) {
                        throw new FlowableObjectNotFoundException("No decision found for key: " + decisionKey + ". There was also no fall back decision found for default tenant " + defaultTenant + ".");
                    }
                } else {
                    decision = decisionEntityManager.findLatestDecisionByKey(decisionKey);
                    if (decision == null) {
                        throw new FlowableObjectNotFoundException("No decision found for key: " + decisionKey + ". There was also no fall back decision found without tenant.");
                    }
                }
            }
        } else {
            if (!StringUtils.isNotEmpty((CharSequence)decisionKey)) throw new FlowableIllegalArgumentException("decisionKey is null");
            decision = decisionEntityManager.findLatestDecisionByKey(decisionKey);
            if (decision == null) {
                throw new FlowableObjectNotFoundException("No decision found for key: " + decisionKey + ".");
            }
        }
        this.executeDecisionContext.setDecisionId(decision.getId());
        this.executeDecisionContext.setDecisionVersion(decision.getVersion());
        this.executeDecisionContext.setDeploymentId(decision.getDeploymentId());
        DecisionCacheEntry decisionTableCacheEntry = CommandContextUtil.getDmnEngineConfiguration().getDeploymentManager().resolveDecision(decision);
        return decisionTableCacheEntry.getDmnDefinition();
    }

    protected void execute(CommandContext commandContext, DmnDefinition definition) {
        Decision decision = definition.getDecisionById(this.executeDecisionContext.getDecisionKey());
        if (decision == null) {
            throw new FlowableIllegalArgumentException("no decision with id: '" + this.executeDecisionContext.getDecisionKey() + "' found in definition");
        }
        this.executeDecisionContext.setDmnElement((DmnElement)decision);
        CommandContextUtil.getAgenda(commandContext).planExecuteDecisionOperation(this.executeDecisionContext, decision);
    }
}

