/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl;

import org.flowable.common.engine.api.Engine;
import org.flowable.common.engine.api.engine.EngineLifecycleListener;
import org.flowable.dmn.api.DmnDecisionService;
import org.flowable.dmn.api.DmnHistoryService;
import org.flowable.dmn.api.DmnManagementService;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.DmnEngines;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnEngineImpl
implements DmnEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmnEngineImpl.class);
    protected String name;
    protected DmnManagementService dmnManagementService;
    protected DmnRepositoryService dmnRepositoryService;
    protected DmnDecisionService dmnDecisionService;
    protected DmnHistoryService dmnHistoryService;
    protected DmnEngineConfiguration dmnEngineConfiguration;

    public DmnEngineImpl(DmnEngineConfiguration dmnEngineConfiguration) {
        this.dmnEngineConfiguration = dmnEngineConfiguration;
        this.name = dmnEngineConfiguration.getEngineName();
        this.dmnManagementService = dmnEngineConfiguration.getDmnManagementService();
        this.dmnRepositoryService = dmnEngineConfiguration.getDmnRepositoryService();
        this.dmnDecisionService = dmnEngineConfiguration.getDmnDecisionService();
        this.dmnHistoryService = dmnEngineConfiguration.getDmnHistoryService();
        if (dmnEngineConfiguration.getSchemaManagementCmd() != null) {
            dmnEngineConfiguration.getCommandExecutor().execute(dmnEngineConfiguration.getSchemaCommandConfig(), dmnEngineConfiguration.getSchemaManagementCmd());
        }
        if (this.name == null) {
            LOGGER.info("default flowable DmnEngine created");
        } else {
            LOGGER.info("DmnEngine {} created", (Object)this.name);
        }
        DmnEngines.registerDmnEngine(this);
        if (dmnEngineConfiguration.getEngineLifecycleListeners() != null) {
            for (EngineLifecycleListener engineLifecycleListener : dmnEngineConfiguration.getEngineLifecycleListeners()) {
                engineLifecycleListener.onEngineBuilt((Engine)this);
            }
        }
    }

    public void close() {
        DmnEngines.unregister(this);
        this.dmnEngineConfiguration.close();
        if (this.dmnEngineConfiguration.getEngineLifecycleListeners() != null) {
            for (EngineLifecycleListener engineLifecycleListener : this.dmnEngineConfiguration.getEngineLifecycleListeners()) {
                engineLifecycleListener.onEngineClosed((Engine)this);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public DmnManagementService getDmnManagementService() {
        return this.dmnManagementService;
    }

    @Override
    public DmnRepositoryService getDmnRepositoryService() {
        return this.dmnRepositoryService;
    }

    @Override
    public DmnDecisionService getDmnDecisionService() {
        return this.dmnDecisionService;
    }

    @Override
    public DmnHistoryService getDmnHistoryService() {
        return this.dmnHistoryService;
    }

    @Override
    public DmnEngineConfiguration getDmnEngineConfiguration() {
        return this.dmnEngineConfiguration;
    }
}

