/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.dmn.api.DecisionServiceExecutionAuditContainer;
import org.flowable.dmn.api.DmnDecisionService;
import org.flowable.dmn.api.ExecuteDecisionBuilder;
import org.flowable.dmn.api.ExecuteDecisionContext;

public class ExecuteDecisionBuilderImpl
implements ExecuteDecisionBuilder {
    protected DmnDecisionService decisionService;
    protected String decisionKey;
    protected String parentDeploymentId;
    protected String instanceId;
    protected String executionId;
    protected String activityId;
    protected String scopeType;
    protected String tenantId;
    protected Map<String, Object> variables;
    protected boolean fallbackToDefaultTenant;

    public ExecuteDecisionBuilderImpl(DmnDecisionService decisionService) {
        this.decisionService = decisionService;
    }

    public ExecuteDecisionBuilder decisionKey(String decisionKey) {
        this.decisionKey = decisionKey;
        return this;
    }

    public ExecuteDecisionBuilder parentDeploymentId(String parentDeploymentId) {
        this.parentDeploymentId = parentDeploymentId;
        return this;
    }

    public ExecuteDecisionBuilder instanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public ExecuteDecisionBuilder executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    public ExecuteDecisionBuilder activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    public ExecuteDecisionBuilder scopeType(String scopeType) {
        this.scopeType = scopeType;
        return this;
    }

    public ExecuteDecisionBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public ExecuteDecisionBuilder fallbackToDefaultTenant() {
        this.fallbackToDefaultTenant = true;
        return this;
    }

    public ExecuteDecisionBuilder variables(Map<String, Object> variables) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.variables.put(variableName, variables.get(variableName));
            }
        }
        return this;
    }

    public ExecuteDecisionBuilder variable(String variableName, Object value) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(variableName, value);
        return this;
    }

    @Deprecated
    public List<Map<String, Object>> execute() {
        return this.decisionService.executeDecision((ExecuteDecisionBuilder)this);
    }

    public List<Map<String, Object>> executeDecision() {
        return this.decisionService.executeDecision((ExecuteDecisionBuilder)this);
    }

    public Map<String, List<Map<String, Object>>> executeDecisionService() {
        return this.decisionService.executeDecisionService((ExecuteDecisionBuilder)this);
    }

    public Map<String, Object> executeWithSingleResult() {
        return this.decisionService.executeWithSingleResult((ExecuteDecisionBuilder)this);
    }

    public Map<String, Object> executeDecisionWithSingleResult() {
        return this.decisionService.executeDecisionWithSingleResult((ExecuteDecisionBuilder)this);
    }

    public Map<String, Object> executeDecisionServiceWithSingleResult() {
        return this.decisionService.executeDecisionServiceWithSingleResult((ExecuteDecisionBuilder)this);
    }

    public DecisionExecutionAuditContainer executeWithAuditTrail() {
        return this.decisionService.executeWithAuditTrail((ExecuteDecisionBuilder)this);
    }

    public DecisionExecutionAuditContainer executeDecisionWithAuditTrail() {
        return this.decisionService.executeDecisionWithAuditTrail((ExecuteDecisionBuilder)this);
    }

    public DecisionServiceExecutionAuditContainer executeDecisionServiceWithAuditTrail() {
        return this.decisionService.executeDecisionServiceWithAuditTrail((ExecuteDecisionBuilder)this);
    }

    public String getDecisionKey() {
        return this.decisionKey;
    }

    public String getParentDeploymentId() {
        return this.parentDeploymentId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isFallbackToDefaultTenant() {
        return this.fallbackToDefaultTenant;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public ExecuteDecisionContext buildExecuteDecisionContext() {
        ExecuteDecisionContext executeDecisionContext = new ExecuteDecisionContext();
        executeDecisionContext.setDecisionKey(this.decisionKey);
        executeDecisionContext.setParentDeploymentId(this.parentDeploymentId);
        executeDecisionContext.setInstanceId(this.instanceId);
        executeDecisionContext.setExecutionId(this.executionId);
        executeDecisionContext.setActivityId(this.activityId);
        executeDecisionContext.setScopeType(this.scopeType);
        executeDecisionContext.setVariables(this.variables);
        executeDecisionContext.setTenantId(this.tenantId);
        executeDecisionContext.setFallbackToDefaultTenant(this.fallbackToDefaultTenant);
        return executeDecisionContext;
    }
}

