/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.hitpolicy;

import java.util.ArrayList;
import java.util.Map;
import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.dmn.engine.impl.el.ELExecutionContext;
import org.flowable.dmn.engine.impl.hitpolicy.ComposeDecisionResultBehavior;
import org.flowable.dmn.engine.impl.hitpolicy.ComposeRuleResultBehavior;
import org.flowable.dmn.engine.impl.hitpolicy.ContinueEvaluatingBehavior;

public abstract class AbstractHitPolicy
implements ContinueEvaluatingBehavior,
ComposeRuleResultBehavior,
ComposeDecisionResultBehavior {
    protected boolean multipleResults = false;

    public AbstractHitPolicy() {
    }

    public AbstractHitPolicy(boolean multipleResults) {
        this.multipleResults = multipleResults;
    }

    public abstract String getHitPolicyName();

    @Override
    public boolean shouldContinueEvaluating(boolean ruleResult) {
        return true;
    }

    @Override
    public void composeRuleResult(int ruleNumber, String outputName, Object outputValue, ELExecutionContext executionContext) {
        executionContext.addRuleResult(ruleNumber, outputName, outputValue);
    }

    @Override
    public void composeDecisionResults(ELExecutionContext executionContext) {
        ArrayList<Map<String, Object>> decisionResults = new ArrayList<Map<String, Object>>(executionContext.getRuleResults().values());
        DecisionExecutionAuditContainer auditContainer = executionContext.getAuditContainer();
        auditContainer.setDecisionResult(decisionResults);
        auditContainer.setMultipleResults(this.multipleResults);
    }
}

