/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl;

import java.util.List;
import java.util.Set;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.query.AbstractQuery;
import org.flowable.dmn.api.DmnDecision;
import org.flowable.dmn.api.DmnDecisionQuery;
import org.flowable.dmn.engine.impl.DecisionQueryProperty;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;

public class DecisionQueryImpl
extends AbstractQuery<DmnDecisionQuery, DmnDecision>
implements DmnDecisionQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected Set<String> ids;
    protected String category;
    protected String categoryLike;
    protected String categoryNotEquals;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected Set<String> deploymentIds;
    protected String key;
    protected String keyLike;
    protected String resourceName;
    protected String resourceNameLike;
    protected Integer version;
    protected Integer versionGt;
    protected Integer versionGte;
    protected Integer versionLt;
    protected Integer versionLte;
    protected boolean latest;
    protected String decisionId;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected String decisionType;
    protected String decisionTypeLike;

    public DecisionQueryImpl() {
    }

    public DecisionQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public DecisionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public DecisionQueryImpl decisionId(String decisionId) {
        this.id = decisionId;
        return this;
    }

    public DmnDecisionQuery decisionIds(Set<String> decisionIds) {
        this.ids = decisionIds;
        return this;
    }

    public DecisionQueryImpl decisionCategory(String category) {
        if (category == null) {
            throw new FlowableIllegalArgumentException("category is null");
        }
        this.category = category;
        return this;
    }

    public DecisionQueryImpl decisionCategoryLike(String categoryLike) {
        if (categoryLike == null) {
            throw new FlowableIllegalArgumentException("categoryLike is null");
        }
        this.categoryLike = categoryLike;
        return this;
    }

    public DecisionQueryImpl decisionCategoryNotEquals(String categoryNotEquals) {
        if (categoryNotEquals == null) {
            throw new FlowableIllegalArgumentException("categoryNotEquals is null");
        }
        this.categoryNotEquals = categoryNotEquals;
        return this;
    }

    public DecisionQueryImpl decisionName(String name) {
        if (name == null) {
            throw new FlowableIllegalArgumentException("name is null");
        }
        this.name = name;
        return this;
    }

    public DecisionQueryImpl decisionNameLike(String nameLike) {
        if (nameLike == null) {
            throw new FlowableIllegalArgumentException("nameLike is null");
        }
        this.nameLike = nameLike;
        return this;
    }

    public DecisionQueryImpl deploymentId(String deploymentId) {
        if (deploymentId == null) {
            throw new FlowableIllegalArgumentException("id is null");
        }
        this.deploymentId = deploymentId;
        return this;
    }

    public DecisionQueryImpl deploymentIds(Set<String> deploymentIds) {
        if (deploymentIds == null) {
            throw new FlowableIllegalArgumentException("ids are null");
        }
        this.deploymentIds = deploymentIds;
        return this;
    }

    public DecisionQueryImpl decisionKey(String key) {
        if (key == null) {
            throw new FlowableIllegalArgumentException("key is null");
        }
        this.key = key;
        return this;
    }

    public DecisionQueryImpl decisionKeyLike(String keyLike) {
        if (keyLike == null) {
            throw new FlowableIllegalArgumentException("keyLike is null");
        }
        this.keyLike = keyLike;
        return this;
    }

    public DecisionQueryImpl decisionResourceName(String resourceName) {
        if (resourceName == null) {
            throw new FlowableIllegalArgumentException("resourceName is null");
        }
        this.resourceName = resourceName;
        return this;
    }

    public DecisionQueryImpl decisionResourceNameLike(String resourceNameLike) {
        if (resourceNameLike == null) {
            throw new FlowableIllegalArgumentException("resourceNameLike is null");
        }
        this.resourceNameLike = resourceNameLike;
        return this;
    }

    public DecisionQueryImpl decisionVersion(Integer version) {
        this.checkVersion(version);
        this.version = version;
        return this;
    }

    public DmnDecisionQuery decisionVersionGreaterThan(Integer decisionVersion) {
        this.checkVersion(decisionVersion);
        this.versionGt = decisionVersion;
        return this;
    }

    public DmnDecisionQuery decisionVersionGreaterThanOrEquals(Integer decisionVersion) {
        this.checkVersion(decisionVersion);
        this.versionGte = decisionVersion;
        return this;
    }

    public DmnDecisionQuery decisionVersionLowerThan(Integer decisionVersion) {
        this.checkVersion(decisionVersion);
        this.versionLt = decisionVersion;
        return this;
    }

    public DmnDecisionQuery decisionVersionLowerThanOrEquals(Integer decisionVersion) {
        this.checkVersion(decisionVersion);
        this.versionLte = decisionVersion;
        return this;
    }

    protected void checkVersion(Integer version) {
        if (version == null) {
            throw new FlowableIllegalArgumentException("version is null");
        }
        if (version <= 0) {
            throw new FlowableIllegalArgumentException("version must be positive");
        }
    }

    public DecisionQueryImpl latestVersion() {
        this.latest = true;
        return this;
    }

    public DmnDecisionQuery decisionTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("decision tenantId is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public DmnDecisionQuery decisionTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("decision tenantId is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    public DmnDecisionQuery decisionWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public DmnDecisionQuery decisionType(String decisionType) {
        this.decisionType = decisionType;
        return this;
    }

    public DmnDecisionQuery decisionTypeLike(String decisionTypeLike) {
        this.decisionTypeLike = decisionTypeLike;
        return this;
    }

    public DmnDecisionQuery orderByDeploymentId() {
        return (DmnDecisionQuery)this.orderBy(DecisionQueryProperty.DECISION_DEPLOYMENT_ID);
    }

    public DmnDecisionQuery orderByDecisionKey() {
        return (DmnDecisionQuery)this.orderBy(DecisionQueryProperty.DECISION_KEY);
    }

    public DmnDecisionQuery orderByDecisionCategory() {
        return (DmnDecisionQuery)this.orderBy(DecisionQueryProperty.DECISION_CATEGORY);
    }

    public DmnDecisionQuery orderByDecisionId() {
        return (DmnDecisionQuery)this.orderBy(DecisionQueryProperty.DECISION_ID);
    }

    public DmnDecisionQuery orderByDecisionVersion() {
        return (DmnDecisionQuery)this.orderBy(DecisionQueryProperty.DECISION_VERSION);
    }

    public DmnDecisionQuery orderByDecisionName() {
        return (DmnDecisionQuery)this.orderBy(DecisionQueryProperty.DECISION_NAME);
    }

    public DmnDecisionQuery orderByTenantId() {
        return (DmnDecisionQuery)this.orderBy(DecisionQueryProperty.DECISION_TENANT_ID);
    }

    public DmnDecisionQuery orderByDecisionType() {
        return (DmnDecisionQuery)this.orderBy(DecisionQueryProperty.DECISION_TYPE);
    }

    public long executeCount(CommandContext commandContext) {
        return CommandContextUtil.getDecisionEntityManager(commandContext).findDecisionCountByQueryCriteria(this);
    }

    public List<DmnDecision> executeList(CommandContext commandContext) {
        return CommandContextUtil.getDecisionEntityManager(commandContext).findDecisionsByQueryCriteria(this);
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public Set<String> getDeploymentIds() {
        return this.deploymentIds;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getIds() {
        return this.ids;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Integer getVersionGt() {
        return this.versionGt;
    }

    public Integer getVersionGte() {
        return this.versionGte;
    }

    public Integer getVersionLt() {
        return this.versionLt;
    }

    public Integer getVersionLte() {
        return this.versionLte;
    }

    public boolean isLatest() {
        return this.latest;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLike() {
        return this.categoryLike;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceNameLike() {
        return this.resourceNameLike;
    }

    public String getCategoryNotEquals() {
        return this.categoryNotEquals;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public String getDecisionType() {
        return this.decisionType;
    }

    public String getDecisionTypeLike() {
        return this.decisionTypeLike;
    }
}

