/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl;

import java.io.InputStream;
import java.util.List;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.service.CommonEngineServiceImpl;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.dmn.api.DmnDecisionTableQuery;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.api.DmnDeploymentBuilder;
import org.flowable.dmn.api.DmnDeploymentQuery;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.api.NativeDecisionTableQuery;
import org.flowable.dmn.api.NativeDmnDeploymentQuery;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.DecisionTableQueryImpl;
import org.flowable.dmn.engine.impl.DmnDeploymentQueryImpl;
import org.flowable.dmn.engine.impl.NativeDecisionTableQueryImpl;
import org.flowable.dmn.engine.impl.NativeDmnDeploymentQueryImpl;
import org.flowable.dmn.engine.impl.cmd.DeleteDeploymentCmd;
import org.flowable.dmn.engine.impl.cmd.DeployCmd;
import org.flowable.dmn.engine.impl.cmd.GetDeploymentDecisionTableCmd;
import org.flowable.dmn.engine.impl.cmd.GetDeploymentDmnResourceCmd;
import org.flowable.dmn.engine.impl.cmd.GetDeploymentResourceCmd;
import org.flowable.dmn.engine.impl.cmd.GetDeploymentResourceNamesCmd;
import org.flowable.dmn.engine.impl.cmd.GetDmnDefinitionCmd;
import org.flowable.dmn.engine.impl.cmd.SetDecisionTableCategoryCmd;
import org.flowable.dmn.engine.impl.cmd.SetDeploymentCategoryCmd;
import org.flowable.dmn.engine.impl.cmd.SetDeploymentParentDeploymentIdCmd;
import org.flowable.dmn.engine.impl.cmd.SetDeploymentTenantIdCmd;
import org.flowable.dmn.engine.impl.repository.DmnDeploymentBuilderImpl;
import org.flowable.dmn.model.DmnDefinition;

public class DmnRepositoryServiceImpl
extends CommonEngineServiceImpl<DmnEngineConfiguration>
implements DmnRepositoryService {
    public DmnDeploymentBuilder createDeployment() {
        return (DmnDeploymentBuilder)this.commandExecutor.execute((Command)new Command<DmnDeploymentBuilder>(){

            public DmnDeploymentBuilder execute(CommandContext commandContext) {
                return new DmnDeploymentBuilderImpl();
            }
        });
    }

    public DmnDeployment deploy(DmnDeploymentBuilderImpl deploymentBuilder) {
        return (DmnDeployment)this.commandExecutor.execute(new DeployCmd(deploymentBuilder));
    }

    public void deleteDeployment(String deploymentId) {
        this.commandExecutor.execute((Command)new DeleteDeploymentCmd(deploymentId));
    }

    public DmnDecisionTableQuery createDecisionTableQuery() {
        return new DecisionTableQueryImpl(this.commandExecutor);
    }

    public NativeDecisionTableQuery createNativeDecisionTableQuery() {
        return new NativeDecisionTableQueryImpl(this.commandExecutor);
    }

    public List<String> getDeploymentResourceNames(String deploymentId) {
        return (List)this.commandExecutor.execute((Command)new GetDeploymentResourceNamesCmd(deploymentId));
    }

    public InputStream getResourceAsStream(String deploymentId, String resourceName) {
        return (InputStream)this.commandExecutor.execute((Command)new GetDeploymentResourceCmd(deploymentId, resourceName));
    }

    public void setDeploymentCategory(String deploymentId, String category) {
        this.commandExecutor.execute((Command)new SetDeploymentCategoryCmd(deploymentId, category));
    }

    public void setDeploymentTenantId(String deploymentId, String newTenantId) {
        this.commandExecutor.execute((Command)new SetDeploymentTenantIdCmd(deploymentId, newTenantId));
    }

    public void changeDeploymentParentDeploymentId(String deploymentId, String newParentDeploymentId) {
        this.commandExecutor.execute((Command)new SetDeploymentParentDeploymentIdCmd(deploymentId, newParentDeploymentId));
    }

    public DmnDeploymentQuery createDeploymentQuery() {
        return new DmnDeploymentQueryImpl(this.commandExecutor);
    }

    public NativeDmnDeploymentQuery createNativeDeploymentQuery() {
        return new NativeDmnDeploymentQueryImpl(this.commandExecutor);
    }

    public DmnDecisionTable getDecisionTable(String decisionTableId) {
        return (DmnDecisionTable)this.commandExecutor.execute((Command)new GetDeploymentDecisionTableCmd(decisionTableId));
    }

    public DmnDefinition getDmnDefinition(String decisionTableId) {
        return (DmnDefinition)this.commandExecutor.execute((Command)new GetDmnDefinitionCmd(decisionTableId));
    }

    public InputStream getDmnResource(String decisionTableId) {
        return (InputStream)this.commandExecutor.execute((Command)new GetDeploymentDmnResourceCmd(decisionTableId));
    }

    public void setDecisionTableCategory(String decisionTableId, String category) {
        this.commandExecutor.execute((Command)new SetDecisionTableCategoryCmd(decisionTableId, category));
    }
}

