/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.dmn.engine.impl.ExecuteDecisionBuilderImpl;
import org.flowable.dmn.engine.impl.ExecuteDecisionInfo;
import org.flowable.dmn.engine.impl.persistence.deploy.DecisionTableCacheEntry;
import org.flowable.dmn.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.flowable.dmn.model.Decision;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;

public abstract class AbstractExecuteDecisionCmd
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected ExecuteDecisionInfo executeDecisionInfo = new ExecuteDecisionInfo();

    public AbstractExecuteDecisionCmd(ExecuteDecisionBuilderImpl decisionBuilder) {
        this.executeDecisionInfo.setDecisionKey(decisionBuilder.getDecisionKey());
        this.executeDecisionInfo.setParentDeploymentId(decisionBuilder.getParentDeploymentId());
        this.executeDecisionInfo.setInstanceId(decisionBuilder.getInstanceId());
        this.executeDecisionInfo.setExecutionId(decisionBuilder.getExecutionId());
        this.executeDecisionInfo.setActivityId(decisionBuilder.getActivityId());
        this.executeDecisionInfo.setScopeType(decisionBuilder.getScopeType());
        this.executeDecisionInfo.setVariables(decisionBuilder.getVariables());
        this.executeDecisionInfo.setTenantId(decisionBuilder.getTenantId());
    }

    public AbstractExecuteDecisionCmd(String decisionKey, Map<String, Object> variables) {
        this.executeDecisionInfo.setDecisionKey(decisionKey);
        this.executeDecisionInfo.setVariables(variables);
    }

    protected DmnDecisionTable resolveDecisionTable(DeploymentManager deploymentManager) {
        DecisionTableEntity decisionTable = null;
        if (StringUtils.isNotEmpty((CharSequence)this.getDecisionKey()) && StringUtils.isNotEmpty((CharSequence)this.getParentDeploymentId()) && StringUtils.isNotEmpty((CharSequence)this.getTenantId())) {
            try {
                decisionTable = deploymentManager.findDeployedLatestDecisionByKeyParentDeploymentIdAndTenantId(this.getDecisionKey(), this.getParentDeploymentId(), this.getTenantId());
            }
            catch (FlowableObjectNotFoundException e) {
                try {
                    decisionTable = deploymentManager.findDeployedLatestDecisionByKeyAndTenantId(this.getDecisionKey(), this.getTenantId());
                }
                catch (FlowableObjectNotFoundException ex) {
                    throw new FlowableObjectNotFoundException("No decision found for key: " + this.getDecisionKey() + ", parent deployment id " + this.getParentDeploymentId() + " and tenant id: " + this.getTenantId() + ". There was also no fall back decision table found without parent deployment id.");
                }
            }
        } else if (StringUtils.isNotEmpty((CharSequence)this.getDecisionKey()) && StringUtils.isNotEmpty((CharSequence)this.getParentDeploymentId())) {
            try {
                decisionTable = deploymentManager.findDeployedLatestDecisionByKeyAndParentDeploymentId(this.getDecisionKey(), this.getParentDeploymentId());
            }
            catch (FlowableObjectNotFoundException e) {
                try {
                    decisionTable = deploymentManager.findDeployedLatestDecisionByKey(this.getDecisionKey());
                }
                catch (FlowableObjectNotFoundException ex) {
                    throw new FlowableObjectNotFoundException("No decision found for key: " + this.getDecisionKey() + " and parent deployment id " + this.getParentDeploymentId() + ". There was also no fall back decision table found without parent deployment id.");
                }
            }
        } else if (StringUtils.isNotEmpty((CharSequence)this.getDecisionKey()) && StringUtils.isNotEmpty((CharSequence)this.getTenantId())) {
            decisionTable = deploymentManager.findDeployedLatestDecisionByKeyAndTenantId(this.getDecisionKey(), this.getTenantId());
        } else if (StringUtils.isNotEmpty((CharSequence)this.getDecisionKey())) {
            decisionTable = deploymentManager.findDeployedLatestDecisionByKey(this.getDecisionKey());
        } else {
            throw new FlowableIllegalArgumentException("decisionKey is null");
        }
        this.executeDecisionInfo.setDecisionDefinitionId(decisionTable.getId());
        this.executeDecisionInfo.setDeploymentId(decisionTable.getDeploymentId());
        return decisionTable;
    }

    protected Decision resolveDecision(DeploymentManager deploymentManager, DmnDecisionTable decisionTable) {
        if (decisionTable == null) {
            throw new FlowableIllegalArgumentException("decisionTable is null");
        }
        DecisionTableCacheEntry decisionTableCacheEntry = deploymentManager.resolveDecisionTable(decisionTable);
        Decision decision = decisionTableCacheEntry.getDecision();
        return decision;
    }

    protected String getDecisionKey() {
        return this.executeDecisionInfo.getDecisionKey();
    }

    protected String getParentDeploymentId() {
        return this.executeDecisionInfo.getParentDeploymentId();
    }

    protected String getTenantId() {
        return this.executeDecisionInfo.getTenantId();
    }
}

