/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import org.flowable.dmn.engine.impl.persistence.deploy.DecisionTableCacheEntry;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.persistence.deploy.DeploymentCache;

public class SetDecisionTableCategoryCmd
implements Command<Void> {
    protected String decisionTableId;
    protected String category;

    public SetDecisionTableCategoryCmd(String decisionTableId, String category) {
        this.decisionTableId = decisionTableId;
        this.category = category;
    }

    public Void execute(CommandContext commandContext) {
        if (this.decisionTableId == null) {
            throw new FlowableIllegalArgumentException("Decision table id is null");
        }
        DecisionTableEntity decisionTable = (DecisionTableEntity)CommandContextUtil.getDecisionTableEntityManager(commandContext).findById(this.decisionTableId);
        if (decisionTable == null) {
            throw new FlowableObjectNotFoundException("No decision table found for id = '" + this.decisionTableId + "'");
        }
        decisionTable.setCategory(this.category);
        DeploymentCache<DecisionTableCacheEntry> decisionTableCache = CommandContextUtil.getDmnEngineConfiguration().getDecisionCache();
        if (decisionTableCache != null) {
            decisionTableCache.remove(this.decisionTableId);
        }
        CommandContextUtil.getDecisionTableEntityManager(commandContext).update(decisionTable);
        return null;
    }

    public String getDecisionTableId() {
        return this.decisionTableId;
    }

    public void setDecisionTableId(String decisionTableId) {
        this.decisionTableId = decisionTableId;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

