/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl;

import java.util.List;
import java.util.Map;
import org.flowable.engine.common.BaseNativeQuery;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.query.NativeQuery;
import org.flowable.engine.common.impl.context.Context;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandExecutor;

public abstract class AbstractNativeQuery<T extends NativeQuery<?, ?>, U>
extends BaseNativeQuery<T, U>
implements Command<Object> {
    private static final long serialVersionUID = 1L;
    protected transient CommandExecutor commandExecutor;
    protected transient CommandContext commandContext;

    protected AbstractNativeQuery(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public AbstractNativeQuery(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    public AbstractNativeQuery<T, U> setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    public T sql(String sqlStatement) {
        this.sqlStatement = sqlStatement;
        return (T)((Object)this);
    }

    public T parameter(String name, Object value) {
        this.parameters.put(name, value);
        return (T)((Object)this);
    }

    public U singleResult() {
        this.resultType = BaseNativeQuery.ResultType.SINGLE_RESULT;
        if (this.commandExecutor != null) {
            return (U)this.commandExecutor.execute((Command)this);
        }
        return this.executeSingleResult(Context.getCommandContext());
    }

    public List<U> list() {
        this.resultType = BaseNativeQuery.ResultType.LIST;
        if (this.commandExecutor != null) {
            return (List)this.commandExecutor.execute((Command)this);
        }
        return this.executeList(Context.getCommandContext(), this.generateParameterMap());
    }

    public List<U> listPage(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.resultType = BaseNativeQuery.ResultType.LIST_PAGE;
        if (this.commandExecutor != null) {
            return (List)this.commandExecutor.execute((Command)this);
        }
        return this.executeList(Context.getCommandContext(), this.generateParameterMap());
    }

    public long count() {
        this.resultType = BaseNativeQuery.ResultType.COUNT;
        if (this.commandExecutor != null) {
            return (Long)this.commandExecutor.execute((Command)this);
        }
        return this.executeCount(Context.getCommandContext(), this.generateParameterMap());
    }

    public Object execute(CommandContext commandContext) {
        if (this.resultType == BaseNativeQuery.ResultType.LIST) {
            return this.executeList(commandContext, this.generateParameterMap());
        }
        if (this.resultType == BaseNativeQuery.ResultType.LIST_PAGE) {
            return this.executeList(commandContext, this.generateParameterMap());
        }
        if (this.resultType == BaseNativeQuery.ResultType.SINGLE_RESULT) {
            return this.executeSingleResult(commandContext);
        }
        return this.executeCount(commandContext, this.generateParameterMap());
    }

    public abstract long executeCount(CommandContext var1, Map<String, Object> var2);

    public abstract List<U> executeList(CommandContext var1, Map<String, Object> var2);

    public U executeSingleResult(CommandContext commandContext) {
        List<U> results = this.executeList(commandContext, this.generateParameterMap());
        if (results.size() == 1) {
            return results.get(0);
        }
        if (results.size() > 1) {
            throw new FlowableException("Query return " + results.size() + " results instead of max 1");
        }
        return null;
    }
}

