/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.mvel;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.flowable.dmn.engine.impl.audit.DecisionExecutionAuditUtil;
import org.flowable.dmn.engine.impl.mvel.ExecutionVariableFactory;
import org.flowable.dmn.engine.impl.mvel.MvelExecutionContext;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionTable;
import org.flowable.dmn.model.InputClause;
import org.flowable.dmn.model.OutputClause;
import org.flowable.engine.common.api.FlowableException;
import org.joda.time.LocalDate;
import org.mvel2.ParserContext;
import org.mvel2.integration.PropertyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MvelExecutionContextBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MvelExecutionContextBuilder.class);

    public static MvelExecutionContext build(Decision decision, Map<String, Object> inputVariables, Map<String, Method> customExpressionFunctions, Map<Class<?>, PropertyHandler> propertyHandlers) {
        DecisionTable decisionTable;
        MvelExecutionContext executionContext = new MvelExecutionContext();
        executionContext.setAuditContainer(DecisionExecutionAuditUtil.initializeRuleExecutionAudit(decision, inputVariables));
        ParserContext parserContext = new ParserContext();
        if (customExpressionFunctions != null && !customExpressionFunctions.isEmpty()) {
            for (Map.Entry entry : customExpressionFunctions.entrySet()) {
                parserContext.addImport((String)entry.getKey(), (Method)entry.getValue());
            }
        }
        executionContext.setParserContext(parserContext);
        if (propertyHandlers != null) {
            for (Class clazz : propertyHandlers.keySet()) {
                executionContext.addPropertyHandler(clazz, propertyHandlers.get(clazz));
            }
        }
        if ((decisionTable = (DecisionTable)decision.getExpression()).getOutputs() != null) {
            for (OutputClause outputClause : decisionTable.getOutputs()) {
                if (outputClause.getOutputValues() == null || outputClause.getOutputValues().getTextValues() == null) continue;
                executionContext.addOutputValues(outputClause.getName(), ExecutionVariableFactory.getExecutionVariables(outputClause.getTypeRef(), outputClause.getOutputValues().getTextValues()));
            }
        }
        if (decisionTable.getAggregation() != null) {
            executionContext.setAggregator(decisionTable.getAggregation());
        }
        MvelExecutionContextBuilder.preProcessInputVariables(decisionTable, inputVariables);
        executionContext.setStackVariables(inputVariables);
        logger.debug("Execution Context created");
        return executionContext;
    }

    protected static void preProcessInputVariables(DecisionTable decisionTable, Map<String, Object> inputVariables) {
        if (inputVariables == null) {
            inputVariables = new HashMap<String, Object>();
        }
        for (InputClause inputClause : decisionTable.getInputs()) {
            if (inputVariables.containsKey(inputClause.getInputExpression().getText()) || !"boolean".equals(inputClause.getInputExpression().getTypeRef())) continue;
            inputVariables.put(inputClause.getInputExpression().getText(), Boolean.FALSE);
        }
        for (OutputClause outputClause : decisionTable.getOutputs()) {
            if (inputVariables.containsKey(outputClause.getName()) && inputVariables.get(outputClause.getName()) != null) continue;
            if ("number".equals(outputClause.getTypeRef())) {
                inputVariables.put(outputClause.getName(), 0.0);
                continue;
            }
            if ("date".equals(outputClause.getTypeRef())) {
                inputVariables.put(outputClause.getName(), new Date());
                continue;
            }
            inputVariables.put(outputClause.getName(), "");
        }
        for (Map.Entry entry : inputVariables.entrySet()) {
            try {
                if (!(entry.getValue() instanceof LocalDate)) continue;
                Date transformedDate = ((LocalDate)entry.getValue()).toDate();
                inputVariables.put((String)entry.getKey(), transformedDate);
            }
            catch (Exception ex) {
                throw new FlowableException("error while transforming variable", (Throwable)ex);
            }
        }
    }
}

