/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.mvel;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.api.FlowableException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionVariableFactory {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionVariableFactory.class);

    public static Object getExecutionVariable(String type, Object expressionResult) {
        Object executionVariable;
        block7: {
            if (type == null || expressionResult == null) {
                logger.error("could not create result variable: type {} expression result {}", (Object)type, expressionResult);
                throw new FlowableException("could not create result variable");
            }
            executionVariable = null;
            try {
                if (StringUtils.equals((CharSequence)"boolean", (CharSequence)type)) {
                    executionVariable = expressionResult instanceof Boolean ? expressionResult : new Boolean(expressionResult.toString());
                    break block7;
                }
                if (StringUtils.equals((CharSequence)"string", (CharSequence)type)) {
                    executionVariable = expressionResult instanceof String ? expressionResult : expressionResult.toString();
                    break block7;
                }
                if (StringUtils.equals((CharSequence)"number", (CharSequence)type)) {
                    executionVariable = expressionResult instanceof Double ? expressionResult : Double.valueOf(expressionResult.toString());
                    break block7;
                }
                if (StringUtils.equals((CharSequence)"date", (CharSequence)type)) {
                    executionVariable = expressionResult instanceof Date ? expressionResult : new DateTime((Object)expressionResult.toString()).toDate();
                    break block7;
                }
                logger.error("could not create result variable: unrecognized mapping type");
                throw new FlowableException("could not create result variable: unrecognized mapping type");
            }
            catch (Exception e) {
                logger.error("could not create result variable", (Throwable)e);
                throw new FlowableException("Could not create execution variable", (Throwable)e);
            }
        }
        return executionVariable;
    }

    public static List<Object> getExecutionVariables(String type, List<Object> expressionResults) {
        if (type == null || expressionResults == null) {
            return null;
        }
        ArrayList<Object> executionVariables = new ArrayList<Object>();
        for (Object expressionResult : expressionResults) {
            executionVariables.add(ExecutionVariableFactory.getExecutionVariable(type, expressionResult));
        }
        return executionVariables;
    }
}

