/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl;

import org.flowable.dmn.api.DmnManagementService;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.api.DmnRuleService;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.DmnEngines;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnEngineImpl
implements DmnEngine {
    private static Logger log = LoggerFactory.getLogger(DmnEngineImpl.class);
    protected String name;
    protected DmnManagementService dmnManagementService;
    protected DmnRepositoryService dmnRepositoryService;
    protected DmnRuleService dmnRuleService;
    protected DmnEngineConfiguration dmnEngineConfiguration;

    public DmnEngineImpl(DmnEngineConfiguration dmnEngineConfiguration) {
        this.dmnEngineConfiguration = dmnEngineConfiguration;
        this.name = dmnEngineConfiguration.getEngineName();
        this.dmnManagementService = dmnEngineConfiguration.getDmnManagementService();
        this.dmnRepositoryService = dmnEngineConfiguration.getDmnRepositoryService();
        this.dmnRuleService = dmnEngineConfiguration.getDmnRuleService();
        if (this.name == null) {
            log.info("default flowable DmnEngine created");
        } else {
            log.info("DmnEngine {} created", (Object)this.name);
        }
        DmnEngines.registerDmnEngine(this);
    }

    @Override
    public void close() {
        DmnEngines.unregister(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DmnManagementService getDmnManagementService() {
        return this.dmnManagementService;
    }

    @Override
    public DmnRepositoryService getDmnRepositoryService() {
        return this.dmnRepositoryService;
    }

    @Override
    public DmnRuleService getDmnRuleService() {
        return this.dmnRuleService;
    }

    @Override
    public DmnEngineConfiguration getDmnEngineConfiguration() {
        return this.dmnEngineConfiguration;
    }
}

