/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.persistence.entity.data.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.DecisionTableQueryImpl;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntityImpl;
import org.flowable.dmn.engine.impl.persistence.entity.data.AbstractDataManager;
import org.flowable.dmn.engine.impl.persistence.entity.data.DecisionTableDataManager;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.Page;

public class MybatisDecisionTableDataManager
extends AbstractDataManager<DecisionTableEntity>
implements DecisionTableDataManager {
    public MybatisDecisionTableDataManager(DmnEngineConfiguration dmnEngineConfiguration) {
        super(dmnEngineConfiguration);
    }

    @Override
    public Class<? extends DecisionTableEntity> getManagedEntityClass() {
        return DecisionTableEntityImpl.class;
    }

    public DecisionTableEntity create() {
        return new DecisionTableEntityImpl();
    }

    @Override
    public DecisionTableEntity findLatestDecisionTableByKey(String decisionTableKey) {
        return (DecisionTableEntity)this.getDbSqlSession().selectOne("selectLatestDecisionTableByKey", decisionTableKey);
    }

    @Override
    public DecisionTableEntity findLatestDecisionTableByKeyAndTenantId(String decisionTableKey, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("decisionTableKey", decisionTableKey);
        params.put("tenantId", tenantId);
        return (DecisionTableEntity)this.getDbSqlSession().selectOne("selectLatestDecisionTableByKeyAndTenantId", params);
    }

    @Override
    public DecisionTableEntity findLatestDecisionTableByKeyAndParentDeploymentId(String decisionTableKey, String parentDeploymentId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("decisionTableKey", decisionTableKey);
        params.put("parentDeploymentId", parentDeploymentId);
        return (DecisionTableEntity)this.getDbSqlSession().selectOne("selectLatestDecisionTableByKeyAndParentDeploymentId", params);
    }

    @Override
    public DecisionTableEntity findLatestDecisionTableByKeyParentDeploymentIdAndTenantId(String decisionTableKey, String parentDeploymentId, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("decisionTableKey", decisionTableKey);
        params.put("parentDeploymentId", parentDeploymentId);
        params.put("tenantId", tenantId);
        return (DecisionTableEntity)this.getDbSqlSession().selectOne("selectLatestDecisionTableByKeyParentDeploymentIdAndTenantId", params);
    }

    @Override
    public void deleteDecisionTablesByDeploymentId(String deploymentId) {
        this.getDbSqlSession().delete("deleteDecisionTablesByDeploymentId", deploymentId);
    }

    @Override
    public List<DmnDecisionTable> findDecisionTablesByQueryCriteria(DecisionTableQueryImpl decisionTableQuery, Page page) {
        return this.getDbSqlSession().selectList("selectDecisionTablesByQueryCriteria", decisionTableQuery, page);
    }

    @Override
    public long findDecisionTableCountByQueryCriteria(DecisionTableQueryImpl decisionTableQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectDecisionTableCountByQueryCriteria", decisionTableQuery);
    }

    @Override
    public DecisionTableEntity findDecisionTableByDeploymentAndKey(String deploymentId, String decisionTableKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("decisionTableKey", decisionTableKey);
        return (DecisionTableEntity)this.getDbSqlSession().selectOne("selectDecisionTableByDeploymentAndKey", parameters);
    }

    @Override
    public DecisionTableEntity findDecisionTableByDeploymentAndKeyAndTenantId(String deploymentId, String decisionTableKey, String tenantId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("decisionTableKey", decisionTableKey);
        parameters.put("tenantId", tenantId);
        return (DecisionTableEntity)this.getDbSqlSession().selectOne("selectDecisionTableByDeploymentAndKeyAndTenantId", parameters);
    }

    @Override
    public DecisionTableEntity findDecisionTableByKeyAndVersion(String decisionTableKey, Integer decisionTableVersion) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("decisionTableKey", decisionTableKey);
        params.put("decisionTableVersion", decisionTableVersion);
        List results = this.getDbSqlSession().selectList("selectDecisionTablesByKeyAndVersion", params);
        if (results.size() == 1) {
            return (DecisionTableEntity)results.get(0);
        }
        if (results.size() > 1) {
            throw new FlowableException("There are " + results.size() + " decision tables with key = '" + decisionTableKey + "' and version = '" + decisionTableVersion + "'.");
        }
        return null;
    }

    @Override
    public DecisionTableEntity findDecisionTableByKeyAndVersionAndTenantId(String decisionTableKey, Integer decisionTableVersion, String tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("decisionTableKey", decisionTableKey);
        params.put("decisionTableVersion", decisionTableVersion);
        params.put("tenantId", tenantId);
        List results = this.getDbSqlSession().selectList("selectDecisionTablesByKeyAndVersionAndTenantId", params);
        if (results.size() == 1) {
            return (DecisionTableEntity)results.get(0);
        }
        if (results.size() > 1) {
            throw new FlowableException("There are " + results.size() + " decision tables with key = '" + decisionTableKey + "' and version = '" + decisionTableVersion + "'.");
        }
        return null;
    }

    @Override
    public List<DmnDecisionTable> findDecisionTablesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectDecisionTableByNativeQuery", parameterMap, firstResult, maxResults);
    }

    @Override
    public long findDecisionTableCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectDecisionTableCountByNativeQuery", parameterMap);
    }

    @Override
    public void updateDecisionTableTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateDecisionTableTenantIdForDeploymentId", params);
    }
}

