/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.mvel;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.dmn.model.BuiltinAggregator;
import org.flowable.engine.common.api.FlowableException;
import org.mvel2.ParserContext;
import org.mvel2.integration.PropertyHandler;

public class MvelExecutionContext {
    protected Map<Integer, Map<String, Object>> ruleResults = new LinkedHashMap<Integer, Map<String, Object>>();
    protected List<Map<String, Object>> decisionResults;
    protected Map<String, Object> stackVariables;
    protected ParserContext parserContext;
    protected Map<Class<?>, PropertyHandler> propertyHandlers = new HashMap();
    protected DecisionExecutionAuditContainer auditContainer;
    protected Map<String, List<Object>> outputValues = new HashMap<String, List<Object>>();
    protected BuiltinAggregator aggregator;

    public void checkExecutionContext(String variableId) {
        if (StringUtils.isEmpty((CharSequence)variableId)) {
            throw new IllegalArgumentException("Variable id cannot be empty");
        }
        if (this.stackVariables == null || this.stackVariables.isEmpty()) {
            throw new IllegalArgumentException("Variables cannot be empty when variable id: " + variableId + " is used");
        }
        if (variableId.contains(".")) {
            String rootVariableId = variableId.substring(0, variableId.indexOf(46));
            if (!this.stackVariables.containsKey(rootVariableId)) {
                throw new FlowableException("referred id: " + rootVariableId + " is not present on the context");
            }
        } else if (!this.stackVariables.containsKey(variableId)) {
            throw new FlowableException("referred id: " + variableId + " is not present on the context");
        }
    }

    public void addRuleResult(int ruleNumber, String outputName, Object outputValue) {
        Map<Object, Object> ruleResult;
        if (this.ruleResults.containsKey(ruleNumber)) {
            ruleResult = this.ruleResults.get(ruleNumber);
        } else {
            ruleResult = new HashMap();
            this.ruleResults.put(ruleNumber, ruleResult);
        }
        ruleResult.put(outputName, outputValue);
    }

    public void setStackVariables(Map<String, Object> variables) {
        this.stackVariables = variables;
    }

    public Map<String, Object> getStackVariables() {
        return this.stackVariables;
    }

    public Map<String, Object> getRuleResult(int ruleNumber) {
        return this.ruleResults.get(ruleNumber);
    }

    public Map<Integer, Map<String, Object>> getRuleResults() {
        return this.ruleResults;
    }

    public ParserContext getParserContext() {
        return this.parserContext;
    }

    public void setParserContext(ParserContext parserContext) {
        this.parserContext = parserContext;
    }

    public Map<Class<?>, PropertyHandler> getPropertyHandlers() {
        return this.propertyHandlers;
    }

    public void addPropertyHandler(Class<?> variableClass, PropertyHandler propertyHandler) {
        this.propertyHandlers.put(variableClass, propertyHandler);
    }

    public DecisionExecutionAuditContainer getAuditContainer() {
        return this.auditContainer;
    }

    public void setAuditContainer(DecisionExecutionAuditContainer auditContainer) {
        this.auditContainer = auditContainer;
    }

    public Map<String, List<Object>> getOutputValues() {
        return this.outputValues;
    }

    public void addOutputValues(String outputName, List<Object> outputValues) {
        this.outputValues.put(outputName, outputValues);
    }

    public void setDecisionResults(List<Map<String, Object>> decisionResults) {
        this.decisionResults = decisionResults;
    }

    public List<Map<String, Object>> getDecisionResults() {
        return this.decisionResults;
    }

    public BuiltinAggregator getAggregator() {
        return this.aggregator;
    }

    public void setAggregator(BuiltinAggregator aggregator) {
        this.aggregator = aggregator;
    }
}

