/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.hitpolicy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.flowable.dmn.engine.impl.context.Context;
import org.flowable.dmn.engine.impl.hitpolicy.AbstractHitPolicy;
import org.flowable.dmn.engine.impl.hitpolicy.ComposeDecisionResultBehavior;
import org.flowable.dmn.engine.impl.hitpolicy.OutputOrderComparator;
import org.flowable.dmn.engine.impl.mvel.MvelExecutionContext;
import org.flowable.dmn.model.HitPolicy;
import org.flowable.engine.common.api.FlowableException;

public class HitPolicyOutputOrder
extends AbstractHitPolicy
implements ComposeDecisionResultBehavior {
    @Override
    public String getHitPolicyName() {
        return HitPolicy.OUTPUT_ORDER.getValue();
    }

    @Override
    public void composeDecisionResults(final MvelExecutionContext executionContext) {
        ArrayList<Map<String, Object>> ruleResults = new ArrayList<Map<String, Object>>(executionContext.getRuleResults().values());
        Collections.sort(ruleResults, new Comparator(){
            boolean noOutputValuesPresent = true;

            public int compare(Object o1, Object o2) {
                CompareToBuilder compareToBuilder = new CompareToBuilder();
                for (Map.Entry<String, List<Object>> entry : executionContext.getOutputValues().entrySet()) {
                    List<Object> outputValues = entry.getValue();
                    if (outputValues == null && outputValues.isEmpty()) continue;
                    this.noOutputValuesPresent = false;
                    compareToBuilder.append(((Map)o1).get(entry.getKey()), ((Map)o2).get(entry.getKey()), (Comparator)new OutputOrderComparator(outputValues.toArray(new Comparable[outputValues.size()])));
                }
                if (!this.noOutputValuesPresent) {
                    return compareToBuilder.toComparison();
                }
                if (Context.getDmnEngineConfiguration().isStrictMode()) {
                    throw new FlowableException(String.format("HitPolicy: %s; no output values present", HitPolicyOutputOrder.this.getHitPolicyName()));
                }
                return 0;
            }
        });
        executionContext.setDecisionResults(ruleResults);
    }
}

