/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import java.util.Map;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.dmn.api.RuleEngineExecutionResult;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.cmd.AbstractExecuteDecisionCmd;
import org.flowable.dmn.engine.impl.interceptor.Command;
import org.flowable.dmn.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.model.Decision;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;

public class ExecuteDecisionSingleResultCmd
extends AbstractExecuteDecisionCmd
implements Command<Map<String, Object>> {
    public ExecuteDecisionSingleResultCmd(String decisionKey, Map<String, Object> variables) {
        this.decisionKey = decisionKey;
        this.variables = variables;
    }

    public ExecuteDecisionSingleResultCmd(String decisionKey, String parentDeploymentId, Map<String, Object> variables) {
        this(decisionKey, variables);
        this.parentDeploymentId = parentDeploymentId;
    }

    public ExecuteDecisionSingleResultCmd(String decisionKey, String parentDeploymentId, Map<String, Object> variables, String tenantId) {
        this(decisionKey, parentDeploymentId, variables);
        this.tenantId = tenantId;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        if (this.decisionKey == null) {
            throw new FlowableIllegalArgumentException("decisionKey is null");
        }
        DmnEngineConfiguration dmnEngineConfiguration = commandContext.getDmnEngineConfiguration();
        DmnDecisionTable decisionTable = this.resolveDecisionTable(dmnEngineConfiguration.getDeploymentManager());
        Decision decision = this.resolveDecision(dmnEngineConfiguration.getDeploymentManager(), decisionTable);
        RuleEngineExecutionResult executionResult = dmnEngineConfiguration.getRuleEngineExecutor().execute(decision, this.variables, dmnEngineConfiguration.getCustomExpressionFunctions(), dmnEngineConfiguration.getCustomPropertyHandlers());
        Map decisionResult = null;
        if (executionResult != null && executionResult.getDecisionResult() != null && !executionResult.getDecisionResult().isEmpty()) {
            if (executionResult.getDecisionResult().size() > 1) {
                throw new FlowableException("more than one result");
            }
            decisionResult = (Map)executionResult.getDecisionResult().get(0);
        }
        return decisionResult;
    }
}

