/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl;

import java.util.List;
import java.util.Set;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.dmn.api.DmnDecisionTableQuery;
import org.flowable.dmn.engine.impl.AbstractQuery;
import org.flowable.dmn.engine.impl.DecisionTableQueryProperty;
import org.flowable.dmn.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.engine.impl.interceptor.CommandExecutor;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.Page;

public class DecisionTableQueryImpl
extends AbstractQuery<DmnDecisionTableQuery, DmnDecisionTable>
implements DmnDecisionTableQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected Set<String> ids;
    protected String category;
    protected String categoryLike;
    protected String categoryNotEquals;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected Set<String> deploymentIds;
    protected String parentDeploymentId;
    protected String parentDeploymentIdLike;
    protected String key;
    protected String keyLike;
    protected String resourceName;
    protected String resourceNameLike;
    protected Integer version;
    protected Integer versionGt;
    protected Integer versionGte;
    protected Integer versionLt;
    protected Integer versionLte;
    protected boolean latest;
    protected String decisionTableId;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;

    public DecisionTableQueryImpl() {
    }

    public DecisionTableQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public DecisionTableQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public DecisionTableQueryImpl decisionTableId(String decisionTableId) {
        this.id = decisionTableId;
        return this;
    }

    public DmnDecisionTableQuery decisionTableIds(Set<String> decisionTableIds) {
        this.ids = decisionTableIds;
        return this;
    }

    public DecisionTableQueryImpl decisionTableCategory(String category) {
        if (category == null) {
            throw new FlowableIllegalArgumentException("category is null");
        }
        this.category = category;
        return this;
    }

    public DecisionTableQueryImpl decisionTableCategoryLike(String categoryLike) {
        if (categoryLike == null) {
            throw new FlowableIllegalArgumentException("categoryLike is null");
        }
        this.categoryLike = categoryLike;
        return this;
    }

    public DecisionTableQueryImpl decisionTableCategoryNotEquals(String categoryNotEquals) {
        if (categoryNotEquals == null) {
            throw new FlowableIllegalArgumentException("categoryNotEquals is null");
        }
        this.categoryNotEquals = categoryNotEquals;
        return this;
    }

    public DecisionTableQueryImpl decisionTableName(String name) {
        if (name == null) {
            throw new FlowableIllegalArgumentException("name is null");
        }
        this.name = name;
        return this;
    }

    public DecisionTableQueryImpl decisionTableNameLike(String nameLike) {
        if (nameLike == null) {
            throw new FlowableIllegalArgumentException("nameLike is null");
        }
        this.nameLike = nameLike;
        return this;
    }

    public DecisionTableQueryImpl deploymentId(String deploymentId) {
        if (deploymentId == null) {
            throw new FlowableIllegalArgumentException("id is null");
        }
        this.deploymentId = deploymentId;
        return this;
    }

    public DecisionTableQueryImpl deploymentIds(Set<String> deploymentIds) {
        if (deploymentIds == null) {
            throw new FlowableIllegalArgumentException("ids are null");
        }
        this.deploymentIds = deploymentIds;
        return this;
    }

    public DecisionTableQueryImpl parentDeploymentId(String parentDeploymentId) {
        if (parentDeploymentId == null) {
            throw new FlowableIllegalArgumentException("parentDeploymentId is null");
        }
        this.parentDeploymentId = parentDeploymentId;
        return this;
    }

    public DecisionTableQueryImpl parentDeploymentIdLike(String parentDeploymentIdLike) {
        if (parentDeploymentIdLike == null) {
            throw new FlowableIllegalArgumentException("parentDeploymentIdLike is null");
        }
        this.parentDeploymentIdLike = parentDeploymentIdLike;
        return this;
    }

    public DecisionTableQueryImpl decisionTableKey(String key) {
        if (key == null) {
            throw new FlowableIllegalArgumentException("key is null");
        }
        this.key = key;
        return this;
    }

    public DecisionTableQueryImpl decisionTableKeyLike(String keyLike) {
        if (keyLike == null) {
            throw new FlowableIllegalArgumentException("keyLike is null");
        }
        this.keyLike = keyLike;
        return this;
    }

    public DecisionTableQueryImpl decisionTableResourceName(String resourceName) {
        if (resourceName == null) {
            throw new FlowableIllegalArgumentException("resourceName is null");
        }
        this.resourceName = resourceName;
        return this;
    }

    public DecisionTableQueryImpl decisionTableResourceNameLike(String resourceNameLike) {
        if (resourceNameLike == null) {
            throw new FlowableIllegalArgumentException("resourceNameLike is null");
        }
        this.resourceNameLike = resourceNameLike;
        return this;
    }

    public DecisionTableQueryImpl decisionTableVersion(Integer version) {
        this.checkVersion(version);
        this.version = version;
        return this;
    }

    public DmnDecisionTableQuery decisionTableVersionGreaterThan(Integer decisionTableVersion) {
        this.checkVersion(decisionTableVersion);
        this.versionGt = decisionTableVersion;
        return this;
    }

    public DmnDecisionTableQuery decisionTableVersionGreaterThanOrEquals(Integer decisionTableVersion) {
        this.checkVersion(decisionTableVersion);
        this.versionGte = decisionTableVersion;
        return this;
    }

    public DmnDecisionTableQuery decisionTableVersionLowerThan(Integer decisionTableVersion) {
        this.checkVersion(decisionTableVersion);
        this.versionLt = decisionTableVersion;
        return this;
    }

    public DmnDecisionTableQuery decisionTableVersionLowerThanOrEquals(Integer decisionTableVersion) {
        this.checkVersion(decisionTableVersion);
        this.versionLte = decisionTableVersion;
        return this;
    }

    protected void checkVersion(Integer version) {
        if (version == null) {
            throw new FlowableIllegalArgumentException("version is null");
        }
        if (version <= 0) {
            throw new FlowableIllegalArgumentException("version must be positive");
        }
    }

    public DecisionTableQueryImpl latestVersion() {
        this.latest = true;
        return this;
    }

    public DmnDecisionTableQuery decisionTableTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("decision table tenantId is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public DmnDecisionTableQuery decisionTableTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("decision table tenantId is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    public DmnDecisionTableQuery decisionTableWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public DmnDecisionTableQuery orderByDeploymentId() {
        return (DmnDecisionTableQuery)this.orderBy(DecisionTableQueryProperty.DEPLOYMENT_ID);
    }

    public DmnDecisionTableQuery orderByDecisionTableKey() {
        return (DmnDecisionTableQuery)this.orderBy(DecisionTableQueryProperty.DECISION_TABLE_KEY);
    }

    public DmnDecisionTableQuery orderByDecisionTableCategory() {
        return (DmnDecisionTableQuery)this.orderBy(DecisionTableQueryProperty.DECISION_TABLE_CATEGORY);
    }

    public DmnDecisionTableQuery orderByDecisionTableId() {
        return (DmnDecisionTableQuery)this.orderBy(DecisionTableQueryProperty.DECISION_TABLE_ID);
    }

    public DmnDecisionTableQuery orderByDecisionTableVersion() {
        return (DmnDecisionTableQuery)this.orderBy(DecisionTableQueryProperty.DECISION_TABLE_VERSION);
    }

    public DmnDecisionTableQuery orderByDecisionTableName() {
        return (DmnDecisionTableQuery)this.orderBy(DecisionTableQueryProperty.DECISION_TABLE_NAME);
    }

    public DmnDecisionTableQuery orderByTenantId() {
        return (DmnDecisionTableQuery)this.orderBy(DecisionTableQueryProperty.DECISION_TABLE_TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getDecisionTableEntityManager().findDecisionTableCountByQueryCriteria(this);
    }

    @Override
    public List<DmnDecisionTable> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getDecisionTableEntityManager().findDecisionTablesByQueryCriteria(this, page);
    }

    @Override
    public void checkQueryOk() {
        super.checkQueryOk();
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public Set<String> getDeploymentIds() {
        return this.deploymentIds;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getIds() {
        return this.ids;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Integer getVersionGt() {
        return this.versionGt;
    }

    public Integer getVersionGte() {
        return this.versionGte;
    }

    public Integer getVersionLt() {
        return this.versionLt;
    }

    public Integer getVersionLte() {
        return this.versionLte;
    }

    public boolean isLatest() {
        return this.latest;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLike() {
        return this.categoryLike;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceNameLike() {
        return this.resourceNameLike;
    }

    public String getCategoryNotEquals() {
        return this.categoryNotEquals;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }
}

